/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.distance;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.distance.DistanceCalculationException;
import org.optaweb.vehiclerouting.service.distance.DistanceCalculator;
import org.optaweb.vehiclerouting.service.distance.DistanceMatrixImpl;
import org.optaweb.vehiclerouting.service.location.DistanceMatrixRow;

@ExtendWith(value={MockitoExtension.class})
class DistanceMatrixImplTest {
    @Mock
    private DistanceCalculator distanceCalculator;
    @InjectMocks
    private DistanceMatrixImpl distanceMatrix;

    DistanceMatrixImplTest() {
    }

    @Test
    void should_calculate_distance_map() {
        DistanceMatrixImpl distanceMatrix = new DistanceMatrixImpl((DistanceCalculator)new MockDistanceCalculator());
        Location l0 = DistanceMatrixImplTest.location(100L, 0);
        Location l1 = DistanceMatrixImplTest.location(111L, 1);
        Location l9neg = DistanceMatrixImplTest.location(321L, -9);
        DistanceMatrixRow matrixRow0 = distanceMatrix.addLocation(l0);
        Assertions.assertThat((Object)matrixRow0.distanceTo(l0.id())).isEqualTo((Object)Distance.ZERO);
        Assertions.assertThat((Object)distanceMatrix.distance(l0, l0)).isEqualTo((Object)Distance.ZERO);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> matrixRow0.distanceTo(l1.id()));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> distanceMatrix.distance(l0, l1));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> distanceMatrix.distance(l1, l0));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> distanceMatrix.distance(l1, l1));
        DistanceMatrixRow matrixRow1 = distanceMatrix.addLocation(l1);
        Assertions.assertThat((Object)matrixRow1.distanceTo(l1.id())).isEqualTo((Object)Distance.ZERO);
        Assertions.assertThat((Object)distanceMatrix.distance(l1, l1)).isEqualTo((Object)Distance.ZERO);
        Assertions.assertThat((Object)matrixRow1.distanceTo(l0.id())).isEqualTo((Object)Distance.ofMillis((long)1L));
        Assertions.assertThat((Object)distanceMatrix.distance(l0, l1)).isEqualTo((Object)Distance.ofMillis((long)1L));
        Assertions.assertThat((Object)matrixRow0.distanceTo(l1.id())).isEqualTo((Object)Distance.ofMillis((long)1L));
        Assertions.assertThat((Object)distanceMatrix.distance(l1, l0)).isEqualTo((Object)Distance.ofMillis((long)1L));
        DistanceMatrixRow matrixRow9 = distanceMatrix.addLocation(l9neg);
        Assertions.assertThat((Object)matrixRow9.distanceTo(l0.id())).isEqualTo((Object)Distance.ofMillis((long)9L));
        Assertions.assertThat((Object)distanceMatrix.distance(l9neg, l0)).isEqualTo((Object)Distance.ofMillis((long)9L));
        Assertions.assertThat((Object)matrixRow9.distanceTo(l1.id())).isEqualTo((Object)Distance.ofMillis((long)10L));
        Assertions.assertThat((Object)distanceMatrix.distance(l9neg, l1)).isEqualTo((Object)Distance.ofMillis((long)10L));
        Assertions.assertThat((Object)matrixRow0.distanceTo(l9neg.id())).isEqualTo((Object)Distance.ofMillis((long)9L));
        Assertions.assertThat((Object)distanceMatrix.distance(l0, l9neg)).isEqualTo((Object)Distance.ofMillis((long)9L));
        Assertions.assertThat((Object)matrixRow1.distanceTo(l9neg.id())).isEqualTo((Object)Distance.ofMillis((long)10L));
        Assertions.assertThat((Object)distanceMatrix.distance(l1, l9neg)).isEqualTo((Object)Distance.ofMillis((long)10L));
        Assertions.assertThat((int)distanceMatrix.dimension()).isEqualTo(3);
        distanceMatrix.clear();
        Assertions.assertThat((int)distanceMatrix.dimension()).isZero();
        Location l500 = DistanceMatrixImplTest.location(500L, 500);
        DistanceMatrixRow matrixRow500 = distanceMatrix.addLocation(l500);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> matrixRow500.distanceTo(l0.id()));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> distanceMatrix.distance(l500, l0));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> matrixRow9.distanceTo(l500.id()));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> distanceMatrix.distance(l9neg, l500));
    }

    @Test
    void should_calculate_distance_only_once() {
        Location l1 = DistanceMatrixImplTest.location(100L, -1);
        Location l2 = DistanceMatrixImplTest.location(111L, 20);
        long dist12 = 12L;
        long dist21 = 21L;
        Mockito.when((Object)this.distanceCalculator.travelTimeMillis(l1.coordinates(), l2.coordinates())).thenReturn((Object)dist12);
        Mockito.when((Object)this.distanceCalculator.travelTimeMillis(l2.coordinates(), l1.coordinates())).thenReturn((Object)dist21);
        this.distanceMatrix.addLocation(l1);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.distanceCalculator});
        this.distanceMatrix.addLocation(l2);
        ((DistanceCalculator)Mockito.verify((Object)this.distanceCalculator)).travelTimeMillis(l1.coordinates(), l2.coordinates());
        ((DistanceCalculator)Mockito.verify((Object)this.distanceCalculator)).travelTimeMillis(l2.coordinates(), l1.coordinates());
        DistanceMatrixRow row21 = this.distanceMatrix.addLocation(l2);
        Assertions.assertThat((Object)row21.distanceTo(l1.id())).isEqualTo((Object)Distance.ofMillis((long)dist21));
        DistanceMatrixRow row12 = this.distanceMatrix.addLocation(l1);
        Assertions.assertThat((Object)row12.distanceTo(l2.id())).isEqualTo((Object)Distance.ofMillis((long)dist12));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.distanceCalculator});
    }

    @Test
    void should_remove_distance_row_from_matrix_and_repository_when_location_removed() {
        Location l1 = DistanceMatrixImplTest.location(1L, 1);
        Location l2 = DistanceMatrixImplTest.location(2L, 2);
        Mockito.when((Object)this.distanceCalculator.travelTimeMillis(l1.coordinates(), l2.coordinates())).thenThrow(new Throwable[]{new DistanceCalculationException("dummy")});
        this.distanceMatrix.addLocation(l1);
        Assertions.assertThatExceptionOfType(DistanceCalculationException.class).isThrownBy(() -> this.distanceMatrix.addLocation(l2));
        Assertions.assertThat((int)this.distanceMatrix.dimension()).isEqualTo(1);
        this.distanceMatrix.removeLocation(l1);
        Assertions.assertThat((int)this.distanceMatrix.dimension()).isZero();
        this.distanceMatrix.addLocation(l2);
        Assertions.assertThat((int)this.distanceMatrix.dimension()).isEqualTo(1);
    }

    @Test
    void get_distance_after_put() {
        Location from = DistanceMatrixImplTest.location(1L, 1);
        Location to = DistanceMatrixImplTest.location(2L, 2);
        Distance distance = Distance.ofMillis((long)2000L);
        this.distanceMatrix.put(from, to, distance);
        Assertions.assertThat((Object)this.distanceMatrix.distance(from, to)).isEqualTo((Object)distance);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.distanceCalculator});
    }

    private static Location location(long id, int longitude) {
        return new Location(id, new Coordinates(BigDecimal.ZERO, BigDecimal.valueOf(longitude)));
    }

    private static class MockDistanceCalculator
    implements DistanceCalculator {
        private MockDistanceCalculator() {
        }

        public long travelTimeMillis(Coordinates from, Coordinates to) {
            return (long)Math.abs(to.longitude().doubleValue() - from.longitude().doubleValue());
        }
    }
}

