/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.vehicle;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleData;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.service.vehicle.VehiclePlanner;
import org.optaweb.vehiclerouting.service.vehicle.VehicleRepository;
import org.optaweb.vehiclerouting.service.vehicle.VehicleService;

@ExtendWith(value={MockitoExtension.class})
class VehicleServiceTest {
    @Captor
    private ArgumentCaptor<Vehicle> vehicleArgumentCaptor;
    @Mock
    private VehiclePlanner planner;
    @Mock
    private VehicleRepository vehicleRepository;
    @InjectMocks
    private VehicleService vehicleService;

    VehicleServiceTest() {
    }

    @Test
    void create_default_vehicle() {
        long vehicleId = 63L;
        String name = "Veh5";
        int capacity = 49;
        Vehicle vehicle = VehicleFactory.createVehicle((long)63L, (String)"Veh5", (int)49);
        Mockito.when((Object)this.vehicleRepository.createVehicle(10)).thenReturn((Object)vehicle);
        Assertions.assertThat((Object)this.vehicleService.createVehicle()).isEqualTo((Object)vehicle);
        ((VehiclePlanner)Mockito.verify((Object)this.planner)).addVehicle((Vehicle)this.vehicleArgumentCaptor.capture());
        Vehicle newVehicle = (Vehicle)this.vehicleArgumentCaptor.getValue();
        Assertions.assertThat((long)newVehicle.id()).isEqualTo(63L);
        Assertions.assertThat((String)newVehicle.name()).isEqualTo("Veh5");
        Assertions.assertThat((int)newVehicle.capacity()).isEqualTo(49);
    }

    @Test
    void createVehicle() {
        long vehicleId = 63L;
        String name = "Veh5";
        int capacity = 101;
        VehicleData vehicleData = VehicleFactory.vehicleData((String)"Veh5", (int)101);
        Vehicle vehicle = VehicleFactory.createVehicle((long)63L, (String)"Veh5", (int)101);
        Mockito.when((Object)this.vehicleRepository.createVehicle(vehicleData)).thenReturn((Object)vehicle);
        Assertions.assertThat((Object)this.vehicleService.createVehicle(vehicleData)).isEqualTo((Object)vehicle);
        ((VehiclePlanner)Mockito.verify((Object)this.planner)).addVehicle(vehicle);
    }

    @Test
    void addVehicle_should_validate_arguments() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.vehicleService.addVehicle(null));
    }

    @Test
    void addVehicle() {
        Vehicle vehicle = VehicleFactory.testVehicle((long)1L);
        this.vehicleService.addVehicle(vehicle);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.vehicleRepository});
        ((VehiclePlanner)Mockito.verify((Object)this.planner)).addVehicle(vehicle);
    }

    @Test
    void removeVehicle() {
        long vehicleId = 8L;
        Vehicle vehicle = VehicleFactory.testVehicle((long)8L);
        Mockito.when((Object)this.vehicleRepository.removeVehicle(8L)).thenReturn((Object)vehicle);
        this.vehicleService.removeVehicle(8L);
        ((VehicleRepository)Mockito.verify((Object)this.vehicleRepository)).removeVehicle(8L);
        ((VehiclePlanner)Mockito.verify((Object)this.planner)).removeVehicle(vehicle);
    }

    @Test
    void removeAnyVehicle_should_remove_oldest_vehicle() {
        long vehicleId1 = 1L;
        long vehicleId2 = 2L;
        long vehicleId3 = 3L;
        Vehicle vehicle1 = VehicleFactory.testVehicle((long)1L);
        Vehicle vehicle2 = VehicleFactory.testVehicle((long)2L);
        Vehicle vehicle3 = VehicleFactory.testVehicle((long)3L);
        Mockito.when((Object)this.vehicleRepository.vehicles()).thenReturn(Arrays.asList(vehicle3, vehicle1, vehicle2));
        Mockito.when((Object)this.vehicleRepository.removeVehicle(1L)).thenReturn((Object)vehicle1);
        this.vehicleService.removeAnyVehicle();
        ((VehicleRepository)Mockito.verify((Object)this.vehicleRepository)).removeVehicle(1L);
        ((VehiclePlanner)Mockito.verify((Object)this.planner)).removeVehicle(vehicle1);
    }

    @Test
    void removeAll() {
        this.vehicleService.removeAll();
        ((VehiclePlanner)Mockito.verify((Object)this.planner)).removeAllVehicles();
        ((VehicleRepository)Mockito.verify((Object)this.vehicleRepository)).removeAll();
    }

    @Test
    void changeCapacity() {
        long vehicleId = 1L;
        int capacity = 123;
        Vehicle vehicle = VehicleFactory.createVehicle((long)1L, (String)"1", (int)123);
        Mockito.when((Object)this.vehicleRepository.changeCapacity(1L, 123)).thenReturn((Object)vehicle);
        this.vehicleService.changeCapacity(1L, 123);
        ((VehicleRepository)Mockito.verify((Object)this.vehicleRepository)).changeCapacity(1L, 123);
        ((VehiclePlanner)Mockito.verify((Object)this.planner)).changeCapacity((Vehicle)this.vehicleArgumentCaptor.capture());
        Assertions.assertThat((int)((Vehicle)this.vehicleArgumentCaptor.getValue()).capacity()).isEqualTo(123);
    }
}

