/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import com.neovisionaries.i18n.CountryCode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountryCodeValidator {
    private static final Logger logger = LoggerFactory.getLogger(CountryCodeValidator.class);

    private CountryCodeValidator() {
        throw new AssertionError((Object)"Utility class");
    }

    public static List<String> validate(List<String> countryCodes) {
        List upperCaseCountries = Objects.requireNonNull(countryCodes).stream().map(String::toUpperCase).collect(Collectors.toList());
        List invalidCodes = upperCaseCountries.stream().filter(s -> CountryCode.getByAlpha2Code((String)s) == null).collect(Collectors.toList());
        if (!invalidCodes.isEmpty()) {
            throw new IllegalArgumentException("Following elements (" + invalidCodes + ") are not valid ISO 3166-1 alpha-2 country codes");
        }
        List<String> uniqueCountries = upperCaseCountries.stream().distinct().collect(Collectors.toList());
        if (uniqueCountries.size() < countryCodes.size()) {
            logger.warn("Duplicate items were removed from {}", countryCodes);
        }
        return uniqueCountries;
    }
}

