/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.region;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.service.region.BoundingBox;

class BoundingBoxTest {
    BoundingBoxTest() {
    }

    @Test
    void validate_southwest_and_northeast_arguments() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new BoundingBox(Coordinates.of((double)9.9, (double)-1.0), Coordinates.of((double)1.0, (double)1.01))).withMessageMatching(".*\\(9\\.9N.*\\(1\\.0N.*");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new BoundingBox(Coordinates.of((double)-1.0, (double)9.9), Coordinates.of((double)1.01, (double)1.0))).withMessageMatching(".*\\(9\\.9E.*\\(1\\.0E.*");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new BoundingBox(Coordinates.of((double)9.9, (double)9.9), Coordinates.of((double)1.0, (double)1.0))).withMessageMatching(".*\\(9\\.9N.*\\(1\\.0N.*");
    }

    @Test
    void should_fail_if_bounding_box_has_zero_dimension() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new BoundingBox(Coordinates.of((double)0.0, (double)1.0), Coordinates.of((double)0.0, (double)2.0))).withMessageMatching(".*\\(0\\.0N.*\\(0\\.0N.*");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new BoundingBox(Coordinates.of((double)0.0, (double)10.0), Coordinates.of((double)1.0, (double)10.0))).withMessageMatching(".*\\(10\\.0E.*\\(10\\.0E.*");
    }

    @Test
    void constructor_args_not_null() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new BoundingBox(null, Coordinates.of((double)1.0, (double)1.0)));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new BoundingBox(Coordinates.of((double)1.0, (double)1.0), null));
    }

    @Test
    void should_work_with_southwest_and_northeast() {
        Coordinates sw = Coordinates.of((double)-10.0, (double)-100.0);
        Coordinates ne = Coordinates.of((double)20.0, (double)-2.0);
        BoundingBox boundingBox = new BoundingBox(sw, ne);
        Assertions.assertThat((Object)boundingBox.getSouthWest()).isEqualTo((Object)sw);
        Assertions.assertThat((Object)boundingBox.getNorthEast()).isEqualTo((Object)ne);
    }
}

