/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Distance;

class DistanceTest {
    DistanceTest() {
    }

    @Test
    void distance_millis_should_be_same_as_the_given_value() {
        long millis = 123999L;
        Assertions.assertThat((long)Distance.ofMillis((long)millis).millis()).isEqualTo(millis);
    }

    @Test
    void toString_should_contain_units_and_be_human_readable() {
        Assertions.assertThat((Object)Distance.ofMillis((long)133404000L)).hasToString("37h 3m 24s 0ms");
        Assertions.assertThat((Object)Distance.ofMillis((long)3601000L)).hasToString("1h 0m 1s 0ms");
        Assertions.assertThat((Object)Distance.ofMillis((long)5123L)).hasToString("0h 0m 5s 123ms");
    }

    @Test
    void time_must_be_positive_or_zero() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> Distance.ofMillis((long)-1L)).withMessageContaining("(-1)");
        Assertions.assertThatCode(() -> Distance.ofMillis((long)0L)).doesNotThrowAnyException();
    }

    @Test
    void equals_hashCode() {
        long millis = 37L;
        Distance distance = Distance.ofMillis((long)millis);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)distance).isEqualTo((Object)distance)).isEqualTo((Object)Distance.ofMillis((long)millis))).isNotEqualTo(null)).isNotEqualTo((Object)millis)).isNotEqualTo((Object)Distance.ofMillis((long)(millis + 1L)))).hasSameHashCodeAs((Object)Distance.ofMillis((long)millis));
    }
}

