/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.location;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.distance.DistanceRepository;
import org.optaweb.vehiclerouting.service.error.ErrorEvent;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.optaweb.vehiclerouting.service.location.DistanceMatrixRow;
import org.optaweb.vehiclerouting.service.location.LocationPlanner;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.location.LocationService;

@ExtendWith(value={MockitoExtension.class})
class LocationServiceTest {
    @Mock
    private LocationRepository repository;
    @Mock
    private DistanceRepository distanceRepository;
    @Mock
    private LocationPlanner planner;
    @Mock
    private DistanceMatrix distanceMatrix;
    @Mock
    private Event<ErrorEvent> errorEvent;
    @InjectMocks
    private LocationService locationService;
    private final Coordinates coordinates = Coordinates.of((double)0.0, (double)1.0);
    private final Location location = new Location(1L, this.coordinates);

    LocationServiceTest() {
    }

    @Test
    void createLocation_should_validate_arguments() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.locationService.createLocation(null, "x"));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.locationService.createLocation(this.coordinates, null));
    }

    @Test
    void createLocation(@Mock DistanceMatrixRow matrixRow) {
        Distance distance = Distance.ofMillis((long)123L);
        Location existingLocation = new Location(2L, this.coordinates);
        Mockito.when((Object)this.repository.locations()).thenReturn(Arrays.asList(existingLocation));
        String description = "new location";
        Mockito.when((Object)this.repository.createLocation(this.coordinates, description)).thenReturn((Object)this.location);
        Mockito.when((Object)this.distanceMatrix.addLocation((Location)ArgumentMatchers.any())).thenReturn((Object)matrixRow);
        Mockito.when((Object)this.distanceMatrix.distance((Location)ArgumentMatchers.any(), (Location)ArgumentMatchers.any())).thenReturn((Object)distance);
        Mockito.when((Object)matrixRow.distanceTo(ArgumentMatchers.anyLong())).thenReturn((Object)distance);
        Assertions.assertThat((Optional)this.locationService.createLocation(this.coordinates, description)).contains((Object)this.location);
        ((LocationRepository)Mockito.verify((Object)this.repository)).createLocation(this.coordinates, description);
        ((DistanceMatrix)Mockito.verify((Object)this.distanceMatrix)).addLocation(this.location);
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository)).saveDistance(existingLocation, this.location, distance);
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository)).saveDistance(this.location, existingLocation, distance);
        ((LocationPlanner)Mockito.verify((Object)this.planner)).addLocation(this.location, matrixRow);
    }

    @Test
    void addLocation_should_validate_arguments() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.locationService.addLocation(null));
    }

    @Test
    void addLocation(@Mock DistanceMatrixRow matrixRow) {
        Mockito.when((Object)this.distanceMatrix.addLocation((Location)ArgumentMatchers.any())).thenReturn((Object)matrixRow);
        this.locationService.addLocation(this.location);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.repository});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.distanceRepository});
        ((DistanceMatrix)Mockito.verify((Object)this.distanceMatrix)).addLocation(this.location);
        ((LocationPlanner)Mockito.verify((Object)this.planner)).addLocation(this.location, matrixRow);
    }

    @Test
    void removing_depot_should_be_successful_when_it_is_the_last_location() {
        Mockito.when((Object)this.repository.locations()).thenReturn(Collections.singletonList(this.location));
        Mockito.when((Object)this.repository.find(this.location.id())).thenReturn(Optional.of(this.location));
        this.locationService.removeLocation(this.location.id());
        ((LocationRepository)Mockito.verify((Object)this.repository)).removeLocation(this.location.id());
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository)).deleteDistances(this.location);
        ((LocationPlanner)Mockito.verify((Object)this.planner)).removeLocation(this.location);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.errorEvent});
    }

    @Test
    void removing_nonexistent_location_should_publish_error() {
        Mockito.when((Object)this.repository.find(this.location.id())).thenReturn(Optional.empty());
        this.locationService.removeLocation(this.location.id());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.planner});
        ((LocationRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).removeLocation(ArgumentMatchers.anyLong());
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository, (VerificationMode)Mockito.never())).deleteDistances((Location)ArgumentMatchers.any(Location.class));
        ((Event)Mockito.verify(this.errorEvent)).fire((Object)((ErrorEvent)ArgumentMatchers.any(ErrorEvent.class)));
    }

    @Test
    void removing_depot_when_there_are_other_locations_should_publish_error() {
        Location depot = new Location(1L, this.coordinates);
        Location visit = new Location(2L, this.coordinates);
        Mockito.when((Object)this.repository.locations()).thenReturn(Arrays.asList(depot, visit));
        Mockito.when((Object)this.repository.find(depot.id())).thenReturn(Optional.of(depot));
        this.locationService.removeLocation(depot.id());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.planner});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.distanceMatrix});
        ((LocationRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).removeLocation(ArgumentMatchers.anyLong());
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository, (VerificationMode)Mockito.never())).deleteDistances((Location)ArgumentMatchers.any(Location.class));
        ((Event)Mockito.verify(this.errorEvent)).fire((Object)((ErrorEvent)ArgumentMatchers.any(ErrorEvent.class)));
    }

    @Test
    void removing_visit_should_be_successful() {
        Location depot = new Location(1L, this.coordinates);
        Location visit = new Location(2L, this.coordinates);
        Mockito.when((Object)this.repository.locations()).thenReturn(Arrays.asList(depot, visit));
        Mockito.when((Object)this.repository.find(visit.id())).thenReturn(Optional.of(visit));
        this.locationService.removeLocation(visit.id());
        ((LocationPlanner)Mockito.verify((Object)this.planner)).removeLocation(visit);
        ((DistanceMatrix)Mockito.verify((Object)this.distanceMatrix)).removeLocation(visit);
        ((LocationRepository)Mockito.verify((Object)this.repository)).removeLocation(visit.id());
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository)).deleteDistances(visit);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.errorEvent});
    }

    @Test
    void clear() {
        this.locationService.removeAll();
        ((LocationPlanner)Mockito.verify((Object)this.planner)).removeAllLocations();
        ((LocationRepository)Mockito.verify((Object)this.repository)).removeAll();
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository)).deleteAll();
        ((DistanceMatrix)Mockito.verify((Object)this.distanceMatrix)).clear();
    }

    @Test
    void should_not_optimize_and_roll_back_if_distance_calculation_fails() {
        Mockito.when((Object)this.repository.createLocation(this.coordinates, "")).thenReturn((Object)this.location);
        ((DistanceMatrix)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("test exception")}).when((Object)this.distanceMatrix)).addLocation(this.location);
        Assertions.assertThat((Optional)this.locationService.createLocation(this.coordinates, "")).isEmpty();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.planner});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.distanceRepository});
        ((Event)Mockito.verify(this.errorEvent)).fire((Object)((ErrorEvent)ArgumentMatchers.any(ErrorEvent.class)));
        ((LocationRepository)Mockito.verify((Object)this.repository)).removeLocation(this.location.id());
    }

    @Test
    void populate_matrix_should_read_all_distances() {
        Location depot = new Location(1L, this.coordinates);
        Location visit1 = new Location(2L, this.coordinates);
        Location visit2 = new Location(3L, this.coordinates);
        Mockito.when((Object)this.repository.locations()).thenReturn(Arrays.asList(depot, visit1, visit2));
        Mockito.when((Object)this.distanceRepository.getDistance((Location)ArgumentMatchers.any(Location.class), (Location)ArgumentMatchers.any(Location.class))).thenReturn(Optional.of(Distance.ZERO));
        this.locationService.populateDistanceMatrix();
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository, (VerificationMode)Mockito.times((int)6))).getDistance((Location)ArgumentMatchers.any(Location.class), (Location)ArgumentMatchers.any(Location.class));
        ((DistanceMatrix)Mockito.verify((Object)this.distanceMatrix, (VerificationMode)Mockito.times((int)6))).put((Location)ArgumentMatchers.any(Location.class), (Location)ArgumentMatchers.any(Location.class), (Distance)ArgumentMatchers.any(Distance.class));
    }
}

