/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.function.Consumer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.api.solver.change.ProblemChangeDirector;
import org.optaplanner.test.api.solver.change.MockProblemChangeDirector;

public class MockSolver<Solution_> {
    private final Solution_ workingSolution;
    private final MockProblemChangeDirector changeDirector;

    public static <Solution_> MockSolver<Solution_> build(Solution_ solution) {
        MockProblemChangeDirector spy = (MockProblemChangeDirector)Mockito.spy((Object)new MockProblemChangeDirector());
        return new MockSolver<Solution_>(solution, spy);
    }

    private MockSolver(Solution_ workingSolution, MockProblemChangeDirector changeDirector) {
        this.workingSolution = workingSolution;
        this.changeDirector = changeDirector;
    }

    public void addProblemChange(ProblemChange<Solution_> problemChange) {
        problemChange.doChange(this.workingSolution, (ProblemChangeDirector)this.changeDirector);
    }

    public MockProblemChangeDirector.LookUpMockBuilder whenLookingUp(Object forObject) {
        return this.changeDirector.whenLookingUp(forObject);
    }

    public void verifyEntityAdded(Object entity) {
        ((MockProblemChangeDirector)Mockito.verify((Object)this.changeDirector)).addEntity(ArgumentMatchers.same((Object)entity), (Consumer)ArgumentMatchers.any());
    }

    public void verifyEntityRemoved(Object entity) {
        ((MockProblemChangeDirector)Mockito.verify((Object)this.changeDirector)).removeEntity(ArgumentMatchers.same((Object)entity), (Consumer)ArgumentMatchers.any());
    }

    public void verifyVariableChanged(Object entity, String variableName) {
        ((MockProblemChangeDirector)Mockito.verify((Object)this.changeDirector)).changeVariable(ArgumentMatchers.same((Object)entity), (String)ArgumentMatchers.eq((Object)variableName), (Consumer)ArgumentMatchers.any());
    }

    public void verifyProblemFactAdded(Object fact) {
        ((MockProblemChangeDirector)Mockito.verify((Object)this.changeDirector)).addProblemFact(ArgumentMatchers.same((Object)fact), (Consumer)ArgumentMatchers.any());
    }

    public void verifyProblemFactRemoved(Object fact) {
        ((MockProblemChangeDirector)Mockito.verify((Object)this.changeDirector)).removeProblemFact(ArgumentMatchers.same((Object)fact), (Consumer)ArgumentMatchers.any());
    }

    public void verifyProblemPropertyChanged(Object entityOrFact) {
        ((MockProblemChangeDirector)Mockito.verify((Object)this.changeDirector)).changeProblemProperty(ArgumentMatchers.same((Object)entityOrFact), (Consumer)ArgumentMatchers.any());
    }
}

