/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.api.solver.change.ProblemChangeDirector;
import org.optaplanner.test.api.solver.change.MockProblemChangeDirector;
import org.optaweb.vehiclerouting.plugin.planner.MockSolver;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.Standstill;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

class RemoveVehicleTest {
    RemoveVehicleTest() {
    }

    @Test
    void remove_vehicle() {
        PlanningVehicle removedVehicle = PlanningVehicleFactory.testVehicle((long)1L);
        PlanningVehicle otherVehicle = PlanningVehicleFactory.testVehicle((long)2L);
        PlanningDepot depot = new PlanningDepot(PlanningLocationFactory.testLocation((long)1L));
        PlanningVisit firstVisit = PlanningVisitFactory.testVisit((long)1L);
        PlanningVisit lastVisit = PlanningVisitFactory.testVisit((long)2L);
        VehicleRoutingSolution solution = SolutionFactory.solutionFromVisits(Arrays.asList(removedVehicle, otherVehicle), (PlanningDepot)depot, Arrays.asList(firstVisit, lastVisit));
        MockSolver<VehicleRoutingSolution> mockSolver = MockSolver.build(solution);
        removedVehicle.setNextVisit(firstVisit);
        firstVisit.setPreviousStandstill((Standstill)removedVehicle);
        firstVisit.setVehicle(removedVehicle);
        firstVisit.setNextVisit(lastVisit);
        lastVisit.setPreviousStandstill((Standstill)firstVisit);
        lastVisit.setVehicle(removedVehicle);
        mockSolver.addProblemChange((ProblemChange<VehicleRoutingSolution>)new RemoveVehicle(removedVehicle));
        Assertions.assertThat((Object)firstVisit.getPreviousStandstill()).isNull();
        Assertions.assertThat((Object)lastVisit.getPreviousStandstill()).isNull();
        Assertions.assertThat((List)solution.getVehicleList()).containsExactly((Object[])new PlanningVehicle[]{otherVehicle});
        mockSolver.verifyVariableChanged(firstVisit, "previousStandstill");
        mockSolver.verifyVariableChanged(lastVisit, "previousStandstill");
        mockSolver.verifyProblemFactRemoved(removedVehicle);
    }

    @Test
    void fail_fast_if_working_solution_vehicle_list_does_not_contain_working_vehicle() {
        long removedId = 111L;
        long wrongId = 222L;
        PlanningVehicle removedVehicle = PlanningVehicleFactory.testVehicle((long)removedId);
        PlanningVehicle wrongVehicle = PlanningVehicleFactory.testVehicle((long)wrongId);
        PlanningDepot depot = new PlanningDepot(PlanningLocationFactory.testLocation((long)1L));
        VehicleRoutingSolution solution = SolutionFactory.solutionFromVisits(Arrays.asList(wrongVehicle), (PlanningDepot)depot, Collections.emptyList());
        RemoveVehicle removeVehicle = new RemoveVehicle(removedVehicle);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> removeVehicle.doChange(solution, (ProblemChangeDirector)new MockProblemChangeDirector())).withMessageMatching(".*List .*" + wrongId + ".* doesn't contain the working.*" + removedId + ".*");
    }
}

