/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.domain;

import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.planner.domain.DistanceMap;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;

public class PlanningLocationFactory {
    private PlanningLocationFactory() {
        throw new AssertionError((Object)"Utility class");
    }

    public static PlanningLocation fromDomain(Location location) {
        return PlanningLocationFactory.fromDomain(location, PlanningLocationFactory::failFast);
    }

    public static PlanningLocation fromDomain(Location location, DistanceMap distanceMap) {
        return new PlanningLocation(location.id(), location.coordinates().latitude().doubleValue(), location.coordinates().longitude().doubleValue(), distanceMap);
    }

    public static PlanningLocation testLocation(long id) {
        return PlanningLocationFactory.testLocation(id, PlanningLocationFactory::failFast);
    }

    public static PlanningLocation testLocation(long id, DistanceMap distanceMap) {
        return new PlanningLocation(id, 0.0, 0.0, distanceMap);
    }

    private static long failFast(PlanningLocation location) {
        throw new IllegalStateException();
    }
}

