/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.util.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public class ObjectAssert<T>
extends AbstractAssert<ObjectAssert<T>, T> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    protected ObjectAssert(T actual) {
        super(actual, ObjectAssert.class);
    }

    public void serializedIsEqualToJson(String expected) {
        this.isNotNull();
        try {
            String actualSerialized = this.objectMapper.writeValueAsString(this.actual);
            Assertions.assertThat((String)actualSerialized).isEqualToIgnoringWhitespace((CharSequence)expected);
        }
        catch (JsonProcessingException e) {
            throw new AssertionError("ObjectMapper.writeValueAsString(actual) called with actual: <" + this.actual + "> threw an exception.", e);
        }
    }
}

