/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.rest.model;

import java.util.Arrays;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.rest.model.PortableCoordinates;
import org.optaweb.vehiclerouting.plugin.rest.model.PortableLocation;
import org.optaweb.vehiclerouting.plugin.rest.model.PortableRoute;
import org.optaweb.vehiclerouting.plugin.rest.model.PortableVehicle;
import org.optaweb.vehiclerouting.util.jackson.JacksonAssertions;
import org.optaweb.vehiclerouting.util.junit.FileContent;

class PortableRouteTest {
    PortableRouteTest() {
    }

    @Test
    void marshal_to_json(@FileContent(value="portable-route.json") String expectedJson) {
        PortableVehicle vehicle = new PortableVehicle(13L, "Vehicle", 45317);
        PortableLocation depot = PortableRouteTest.visit(8L, 42.6501218, -71.8835449, "Test depot");
        PortableLocation visit1 = PortableRouteTest.visit(100L, 42.7066596, -72.4934873, "Visit 1");
        PortableLocation visit2 = PortableRouteTest.visit(200L, 42.5543343, -71.443828, "Visit 2");
        PortableRoute portableRoute = new PortableRoute(vehicle, depot, Arrays.asList(visit1, visit2), Arrays.asList(Arrays.asList(PortableRouteTest.coordinates(42.65005, -71.88522), PortableRouteTest.coordinates(42.64997, -71.88527)), Arrays.asList(PortableRouteTest.coordinates(42.64994, -71.88537), PortableRouteTest.coordinates(42.64994, -71.88542))));
        JacksonAssertions.assertThat(portableRoute).serializedIsEqualToJson(expectedJson);
    }

    private static PortableLocation visit(long id, double latitude, double longitude, String description) {
        return PortableLocation.fromLocation((Location)new Location(id, Coordinates.of((double)latitude, (double)longitude), description));
    }

    private static PortableCoordinates coordinates(double latitude, double longitude) {
        return PortableCoordinates.fromCoordinates((Coordinates)Coordinates.of((double)latitude, (double)longitude));
    }
}

