/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.LocationData;

class LocationTest {
    LocationTest() {
    }

    @Test
    void constructor_params_must_not_be_null() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new Location(0L, null, ""));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new Location(0L, Coordinates.of((double)1.0, (double)1.0), null));
    }

    @Test
    void locations_are_identified_based_on_id() {
        Coordinates coordinates0 = new Coordinates(BigDecimal.ZERO, BigDecimal.ZERO);
        Coordinates coordinates1 = new Coordinates(BigDecimal.ONE, BigDecimal.ONE);
        String description = "test description";
        long id = 0L;
        Location location = new Location(0L, coordinates0, "test description");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)location).isNotEqualTo((Object)new Location(1L, coordinates0, "test description"))).isNotEqualTo(null)).isNotEqualTo((Object)new LocationData(coordinates0, "test description"))).isEqualTo((Object)location)).isEqualTo((Object)new Location(0L, coordinates0, "test description"))).isEqualTo((Object)new Location(0L, coordinates1, "test description"))).isEqualTo((Object)new Location(0L, coordinates0, "xyz"));
    }

    @Test
    void equal_locations_must_have_same_hashcode() {
        long id = 1L;
        Assertions.assertThat((Object)new Location(id, Coordinates.of((double)1.0, (double)1.0), "description 1")).hasSameHashCodeAs((Object)new Location(id, Coordinates.of((double)2.0, (double)2.0), "description 2"));
    }

    @Test
    void constructor_without_description_should_create_empty_description() {
        Assertions.assertThat((String)new Location(7L, Coordinates.of((double)3.14, (double)4.13)).description()).isEmpty();
    }
}

