/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import io.quarkus.test.TestTransaction;
import io.quarkus.test.junit.QuarkusTest;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceEntity;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceKey;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceRepositoryImpl;

@QuarkusTest
class DistanceRepositoryIntegrationTest {
    @Inject
    DistanceCrudRepository crudRepository;
    private DistanceRepositoryImpl repository;

    DistanceRepositoryIntegrationTest() {
    }

    @BeforeEach
    void setUp() {
        this.repository = new DistanceRepositoryImpl(this.crudRepository);
    }

    @Test
    @TestTransaction
    void panache_repository_should_persist_and_delete_distances() {
        DistanceKey key = new DistanceKey(1L, 2L);
        DistanceEntity entity = new DistanceEntity(key, Long.valueOf(730107L));
        this.crudRepository.persist((Object)entity);
        Assertions.assertThat((long)this.crudRepository.count()).isOne();
        Assertions.assertThat((Object)((DistanceEntity)this.crudRepository.findById((Object)key))).isEqualTo((Object)entity);
        this.crudRepository.deleteById((Object)key);
        Assertions.assertThat((long)this.crudRepository.count()).isZero();
    }

    static DistanceEntity distance(long fromId, long toId) {
        return new DistanceEntity(new DistanceKey(fromId, toId), Long.valueOf(1L));
    }

    @Test
    @TestTransaction
    void delete_by_fromId_or_toId() {
        DistanceEntity distance23 = DistanceRepositoryIntegrationTest.distance(2L, 3L);
        DistanceEntity distance32 = DistanceRepositoryIntegrationTest.distance(3L, 2L);
        this.crudRepository.persist((Object)DistanceRepositoryIntegrationTest.distance(1L, 2L));
        this.crudRepository.persist((Object)DistanceRepositoryIntegrationTest.distance(2L, 1L));
        this.crudRepository.persist((Object)distance23);
        this.crudRepository.persist((Object)distance32);
        this.crudRepository.persist((Object)DistanceRepositoryIntegrationTest.distance(3L, 1L));
        this.crudRepository.persist((Object)DistanceRepositoryIntegrationTest.distance(1L, 3L));
        Assertions.assertThat((long)this.crudRepository.count()).isEqualTo(6L);
        this.crudRepository.deleteByFromIdOrToId(1L);
        Assertions.assertThat((long)this.crudRepository.count()).isEqualTo(2L);
        Assertions.assertThat((Stream)this.crudRepository.findAll().stream()).containsExactly(new Object[]{distance23, distance32});
    }

    @Test
    @TestTransaction
    void should_return_saved_distance() {
        Location location1 = new Location(1L, Coordinates.of((double)7.0, (double)-4.0));
        Location location2 = new Location(2L, Coordinates.of((double)5.0, (double)9.0));
        Distance distance = Distance.ofMillis((long)956766417L);
        this.repository.saveDistance(location1, location2, distance);
        Assertions.assertThat((Optional)this.repository.getDistance(location1, location2)).contains((Object)distance);
    }

    @Test
    void should_return_negative_number_when_distance_not_found() {
        Location location1 = new Location(1L, Coordinates.of((double)7.0, (double)-4.0));
        Location location2 = new Location(2L, Coordinates.of((double)5.0, (double)9.0));
        Assertions.assertThat((Optional)this.repository.getDistance(location1, location2)).isEmpty();
    }
}

