/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.rest.model;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.plugin.rest.model.PortableVehicle;
import org.optaweb.vehiclerouting.util.jackson.JacksonAssertions;

class PortableVehicleTest {
    PortableVehicleTest() {
    }

    @Test
    void marshall_to_json() {
        long id = 321L;
        String name = "Pink: {XY-123} \"B\"";
        int capacity = 78;
        PortableVehicle portableVehicle = new PortableVehicle(id, name, capacity);
        String jsonTemplate = "{\"id\":%d,\"name\":\"%s\",\"capacity\":%d}";
        String expected = String.format(jsonTemplate, id, name.replaceAll("\"", "\\\\\""), capacity);
        JacksonAssertions.assertThat(portableVehicle).serializedIsEqualToJson(expected);
    }

    @Test
    void constructor_params_must_not_be_null() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new PortableVehicle(1L, null, 2));
    }

    @Test
    void fromVehicle() {
        long id = 321L;
        String name = "Pink XY-123 B";
        int capacity = 31;
        PortableVehicle portableVehicle = PortableVehicle.fromVehicle((Vehicle)VehicleFactory.createVehicle((long)id, (String)name, (int)capacity));
        Assertions.assertThat((long)portableVehicle.getId()).isEqualTo(id);
        Assertions.assertThat((String)portableVehicle.getName()).isEqualTo(name);
        Assertions.assertThat((int)portableVehicle.getCapacity()).isEqualTo(capacity);
        Assertions.assertThatNullPointerException().isThrownBy(() -> PortableVehicle.fromVehicle(null)).withMessageContaining("vehicle");
    }

    @Test
    void equals_hashCode_toString() {
        long id = 123456L;
        String name = "x y";
        int capacity = 444111;
        PortableVehicle portableVehicle = new PortableVehicle(id, name, capacity);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)portableVehicle).isNotEqualTo(null)).isNotEqualTo((Object)VehicleFactory.createVehicle((long)id, (String)name, (int)capacity))).isNotEqualTo((Object)new PortableVehicle(id + 1L, name, capacity))).isNotEqualTo((Object)new PortableVehicle(id, name + "z", capacity))).isNotEqualTo((Object)new PortableVehicle(id, name, capacity + 1))).isEqualTo((Object)portableVehicle)).isEqualTo((Object)new PortableVehicle(id, name, capacity))).hasSameHashCodeAs((Object)new PortableVehicle(id, name, capacity))).asString().contains(new CharSequence[]{String.valueOf(id), name, String.valueOf(capacity)});
    }
}

