/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.demo;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.LocationData;
import org.optaweb.vehiclerouting.domain.RoutingProblem;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleData;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.service.demo.DemoService;
import org.optaweb.vehiclerouting.service.demo.RoutingProblemList;
import org.optaweb.vehiclerouting.service.demo.dataset.DataSetMarshaller;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.location.LocationService;
import org.optaweb.vehiclerouting.service.vehicle.VehicleRepository;
import org.optaweb.vehiclerouting.service.vehicle.VehicleService;

@ExtendWith(value={MockitoExtension.class})
class DemoServiceTest {
    @Mock
    private RoutingProblemList routingProblems;
    @Mock
    private LocationService locationService;
    @Mock
    private LocationRepository locationRepository;
    @Mock
    private VehicleService vehicleService;
    @Mock
    private VehicleRepository vehicleRepository;
    @Mock
    private DataSetMarshaller dataSetMarshaller;
    @InjectMocks
    private DemoService demoService;
    @Captor
    private ArgumentCaptor<RoutingProblem> routingProblemCaptor;
    private final String problemName = "Testing problem";
    private final List<VehicleData> vehicles = Arrays.asList(VehicleFactory.vehicleData((String)"v1", (int)10), VehicleFactory.vehicleData((String)"v2", (int)10));
    private final Location depot = new Location(1L, Coordinates.of((double)1.0, (double)7.0), "Depot");
    private final List<Location> visits = Arrays.asList(new Location(2L, Coordinates.of((double)2.0, (double)9.0), "Visit"));
    private final RoutingProblem routingProblem = new RoutingProblem("Testing problem", this.vehicles, (LocationData)this.depot, this.visits);

    DemoServiceTest() {
    }

    @Test
    void demos_should_return_routing_problems() {
        Mockito.when((Object)this.routingProblems.all()).thenReturn(Arrays.asList(this.routingProblem));
        Collection problems = this.demoService.demos();
        Assertions.assertThat((Collection)problems).containsExactly((Object[])new RoutingProblem[]{this.routingProblem});
    }

    @Test
    void loadDemo() {
        Location location = new Location(10L, Coordinates.of((double)1.0, (double)2.0));
        Mockito.when((Object)this.routingProblems.byName("Testing problem")).thenReturn((Object)this.routingProblem);
        Mockito.when((Object)this.locationService.createLocation((Coordinates)ArgumentMatchers.any(Coordinates.class), ArgumentMatchers.anyString())).thenReturn(Optional.of(location));
        this.demoService.loadDemo("Testing problem");
        ((LocationService)Mockito.verify((Object)this.locationService, (VerificationMode)Mockito.times((int)(this.routingProblem.visits().size() + 1)))).createLocation((Coordinates)ArgumentMatchers.any(Coordinates.class), ArgumentMatchers.anyString());
        ((VehicleService)Mockito.verify((Object)this.vehicleService, (VerificationMode)Mockito.times((int)this.routingProblem.vehicles().size()))).createVehicle((VehicleData)ArgumentMatchers.any(VehicleData.class));
    }

    @Test
    void retry_when_adding_location_fails() {
        Mockito.when((Object)this.routingProblems.byName("Testing problem")).thenReturn((Object)this.routingProblem);
        Mockito.when((Object)this.locationService.createLocation((Coordinates)ArgumentMatchers.any(Coordinates.class), ArgumentMatchers.anyString())).thenReturn(Optional.empty());
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.demoService.loadDemo("Testing problem")).withMessageContaining(this.depot.coordinates().toString());
        ((LocationService)Mockito.verify((Object)this.locationService, (VerificationMode)Mockito.times((int)10))).createLocation((Coordinates)ArgumentMatchers.any(Coordinates.class), ArgumentMatchers.anyString());
    }

    @Test
    void export_should_marshal_routing_plans_with_locations_and_vehicles_from_repository() {
        Location depot = new Location(0L, Coordinates.of((double)1.0, (double)2.0), "Depot");
        Location visit1 = new Location(1L, Coordinates.of((double)11.0, (double)22.0), "Visit 1");
        Location visit2 = new Location(2L, Coordinates.of((double)22.0, (double)33.0), "Visit 2");
        Vehicle vehicle1 = VehicleFactory.createVehicle((long)11L, (String)"Vehicle 1", (int)100);
        Vehicle vehicle2 = VehicleFactory.createVehicle((long)12L, (String)"Vehicle 2", (int)200);
        Mockito.when((Object)this.locationRepository.locations()).thenReturn(Arrays.asList(depot, visit1, visit2));
        Mockito.when((Object)this.vehicleRepository.vehicles()).thenReturn(Arrays.asList(vehicle1, vehicle2));
        this.demoService.exportDataSet();
        RoutingProblem routingProblem = this.verifyAndCaptureMarshalledProblem();
        Assertions.assertThat((String)routingProblem.name()).isNotNull();
        Assertions.assertThat((Optional)routingProblem.depot()).contains((Object)depot);
        Assertions.assertThat((List)routingProblem.visits()).containsExactly((Object[])new LocationData[]{visit1, visit2});
        Assertions.assertThat((List)routingProblem.vehicles()).containsExactly((Object[])new VehicleData[]{vehicle1, vehicle2});
    }

    @Test
    void export_should_marshal_empty_routing_plan_when_repositories_empty() {
        Mockito.when((Object)this.locationRepository.locations()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.vehicleRepository.vehicles()).thenReturn(Collections.emptyList());
        this.demoService.exportDataSet();
        RoutingProblem routingProblem = this.verifyAndCaptureMarshalledProblem();
        Assertions.assertThat((String)routingProblem.name()).isNotNull();
        Assertions.assertThat((Optional)routingProblem.depot()).isEmpty();
        Assertions.assertThat((List)routingProblem.visits()).isEmpty();
        Assertions.assertThat((List)routingProblem.vehicles()).isEmpty();
    }

    private RoutingProblem verifyAndCaptureMarshalledProblem() {
        ((DataSetMarshaller)Mockito.verify((Object)this.dataSetMarshaller)).marshal((RoutingProblem)this.routingProblemCaptor.capture());
        return (RoutingProblem)this.routingProblemCaptor.getValue();
    }
}

