/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.domain;

import java.util.Objects;
import org.optaweb.vehiclerouting.plugin.planner.domain.DistanceMap;

public class PlanningLocation {
    private final long id;
    private final double latitude;
    private final double longitude;
    private final DistanceMap travelDistanceMap;

    PlanningLocation(long id, double latitude, double longitude, DistanceMap travelDistanceMap) {
        this.id = id;
        this.latitude = latitude;
        this.longitude = longitude;
        this.travelDistanceMap = Objects.requireNonNull(travelDistanceMap);
    }

    public long getId() {
        return this.id;
    }

    public long distanceTo(PlanningLocation location) {
        if (this == location) {
            return 0L;
        }
        return this.travelDistanceMap.distanceTo(location);
    }

    public double angleTo(PlanningLocation location) {
        double latitudeDifference = location.latitude - this.latitude;
        double longitudeDifference = location.longitude - this.longitude;
        return Math.atan2(latitudeDifference, longitudeDifference);
    }

    public String toString() {
        return "PlanningLocation{latitude=" + this.latitude + ",longitude=" + this.longitude + ",travelDistanceMap=" + this.travelDistanceMap + ",id=" + this.id + "}";
    }
}

