/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.distance;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.distance.DistanceCalculator;
import org.optaweb.vehiclerouting.service.distance.DistanceRepository;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.optaweb.vehiclerouting.service.location.DistanceMatrixRow;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class DistanceMatrixImpl
implements DistanceMatrix {
    private final DistanceCalculator distanceCalculator;
    private final DistanceRepository distanceRepository;
    private final Map<Location, Map<Long, Distance>> matrix = new HashMap();

    @Autowired
    DistanceMatrixImpl(DistanceCalculator distanceCalculator, DistanceRepository distanceRepository) {
        this.distanceCalculator = distanceCalculator;
        this.distanceRepository = distanceRepository;
    }

    public DistanceMatrixRow addLocation(Location newLocation) {
        ConcurrentHashMap<Long, Distance> distancesToOthers = new ConcurrentHashMap<Long, Distance>();
        distancesToOthers.put(newLocation.id(), Distance.ZERO);
        ((Stream)this.matrix.entrySet().stream().parallel()).forEach(distanceRow -> {
            Location other = (Location)distanceRow.getKey();
            Map distancesFromOther = (Map)distanceRow.getValue();
            distancesFromOther.put(newLocation.id(), this.calculateOrRestoreDistance(other, newLocation));
            distancesToOthers.put(other.id(), this.calculateOrRestoreDistance(newLocation, other));
        });
        this.matrix.put(newLocation, distancesToOthers);
        return locationId -> {
            if (!distancesToOthers.containsKey(locationId)) {
                throw new IllegalArgumentException("Distance from " + newLocation + " to " + locationId + " hasn't been recorded.\nWe only know distances to " + distancesToOthers.keySet());
            }
            return (Distance)distancesToOthers.get(locationId);
        };
    }

    private Distance calculateOrRestoreDistance(Location from, Location to) {
        long distance = this.distanceRepository.getDistance(from, to);
        if (distance < 0L) {
            distance = this.distanceCalculator.travelTimeMillis(from.coordinates(), to.coordinates());
            this.distanceRepository.saveDistance(from, to, distance);
        }
        return Distance.ofMillis((long)distance);
    }

    public void removeLocation(Location location) {
        this.matrix.remove(location);
        this.distanceRepository.deleteDistances(location);
    }

    public void clear() {
        this.matrix.clear();
        this.distanceRepository.deleteAll();
    }

    public int dimension() {
        return this.matrix.size();
    }
}

