/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleData;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleEntity;
import org.optaweb.vehiclerouting.service.vehicle.VehicleRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VehicleRepositoryImpl
implements VehicleRepository {
    private static final Logger logger = LoggerFactory.getLogger(VehicleRepositoryImpl.class);
    private final VehicleCrudRepository repository;

    public VehicleRepositoryImpl(VehicleCrudRepository repository) {
        this.repository = repository;
    }

    @Override
    public Vehicle createVehicle(int capacity) {
        long id = ((VehicleEntity)this.repository.save(new VehicleEntity(0L, null, capacity))).getId();
        VehicleEntity vehicleEntity = (VehicleEntity)this.repository.save(new VehicleEntity(id, "Vehicle " + id, capacity));
        Vehicle vehicle = VehicleRepositoryImpl.toDomain(vehicleEntity);
        logger.info("Created vehicle {}.", (Object)vehicle);
        return vehicle;
    }

    @Override
    public Vehicle createVehicle(VehicleData vehicleData) {
        VehicleEntity vehicleEntity = (VehicleEntity)this.repository.save(new VehicleEntity(0L, vehicleData.name(), vehicleData.capacity()));
        Vehicle vehicle = VehicleRepositoryImpl.toDomain(vehicleEntity);
        logger.info("Created vehicle {}.", (Object)vehicle);
        return vehicle;
    }

    @Override
    public List<Vehicle> vehicles() {
        return StreamSupport.stream(this.repository.findAll().spliterator(), false).map(VehicleRepositoryImpl::toDomain).collect(Collectors.toList());
    }

    @Override
    public Vehicle removeVehicle(long id) {
        Optional optionalVehicleEntity = this.repository.findById(id);
        VehicleEntity vehicleEntity = (VehicleEntity)optionalVehicleEntity.orElseThrow(() -> new IllegalArgumentException("Vehicle{id=" + id + "} doesn't exist"));
        this.repository.deleteById(id);
        Vehicle vehicle = VehicleRepositoryImpl.toDomain(vehicleEntity);
        logger.info("Deleted vehicle {}.", (Object)vehicle);
        return vehicle;
    }

    @Override
    public void removeAll() {
        this.repository.deleteAll();
    }

    @Override
    public Optional<Vehicle> find(long vehicleId) {
        return this.repository.findById(vehicleId).map(VehicleRepositoryImpl::toDomain);
    }

    @Override
    public void update(Vehicle vehicle) {
        this.repository.save(new VehicleEntity(vehicle.id(), vehicle.name(), vehicle.capacity()));
    }

    private static Vehicle toDomain(VehicleEntity vehicleEntity) {
        return VehicleFactory.createVehicle(vehicleEntity.getId(), vehicleEntity.getName(), vehicleEntity.getCapacity());
    }
}

