/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.domain;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;

class PlanningVehicleTest {
    PlanningVehicleTest() {
    }

    @Test
    void get_future_visits_should_return_an_iterable_that_iterates_over_all_visits() {
        PlanningVisit visit1 = new PlanningVisit();
        PlanningVisit visit2 = new PlanningVisit();
        PlanningVisit visit3 = new PlanningVisit();
        PlanningVehicle vehicle = new PlanningVehicle();
        vehicle.setNextVisit(visit1);
        visit1.setNextVisit(visit2);
        visit2.setNextVisit(visit3);
        Iterable futureVisits = vehicle.getFutureVisits();
        Assertions.assertThat((Iterable)futureVisits).containsExactly((Object[])new PlanningVisit[]{visit1, visit2, visit3});
    }

    @Test
    void get_future_visits_should_throw_a_NoSuchElementException_when_there_are_no_more_visits() {
        PlanningVehicle vehicle = new PlanningVehicle();
        Iterator futureVisits = vehicle.getFutureVisits().iterator();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(futureVisits::next);
        PlanningVisit visit1 = new PlanningVisit();
        PlanningVisit visit2 = new PlanningVisit();
        vehicle.setNextVisit(visit1);
        visit1.setNextVisit(visit2);
        futureVisits = vehicle.getFutureVisits().iterator();
        futureVisits.next();
        futureVisits.next();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(futureVisits::next);
    }
}

