/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.rest;

import java.io.IOException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.plugin.rest.DataSetDownloadResource;
import org.optaweb.vehiclerouting.service.demo.DemoService;

@ExtendWith(value={MockitoExtension.class})
class DataSetDownloadResourceTest {
    @Mock
    private DemoService demoService;
    @InjectMocks
    private DataSetDownloadResource controller;

    DataSetDownloadResourceTest() {
    }

    @Test
    void export() throws IOException {
        String msg = "dummy string";
        Mockito.when((Object)this.demoService.exportDataSet()).thenReturn((Object)msg);
        Response response = this.controller.exportDataSet();
        Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
        MultivaluedMap headers = response.getHeaders();
        Assertions.assertThat((Object)headers.getFirst((Object)"Content-Length")).isEqualTo((Object)msg.length());
        Assertions.assertThat((Object)headers.getFirst((Object)"Content-Type")).isNotNull();
        Assertions.assertThat((String)headers.getFirst((Object)"Content-Type").toString()).isEqualToIgnoringWhitespace((CharSequence)"text/x-yaml;charset=UTF-8");
        Assertions.assertThat((Object)headers.getFirst((Object)"Content-Disposition")).isNotNull();
        String contentDisposition = headers.getFirst((Object)"Content-Disposition").toString();
        ((AbstractStringAssert)Assertions.assertThat((String)contentDisposition).startsWith((CharSequence)"attachment;")).containsPattern((CharSequence)"; *filename=\".*\\.yaml\"");
    }

    @Test
    void content_length_should_be_number_of_bytes() throws IOException {
        String msg = "\u0985";
        Mockito.when((Object)this.demoService.exportDataSet()).thenReturn((Object)msg);
        Response response = this.controller.exportDataSet();
        Assertions.assertThat((String)response.getHeaderString("Content-Length")).isEqualTo("3");
    }
}

