/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.rest.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.plugin.rest.model.PortableCoordinates;
import org.springframework.boot.test.json.JacksonTester;

class PortableCoordinatesTest {
    private JacksonTester<PortableCoordinates> json;

    PortableCoordinatesTest() {
    }

    @BeforeEach
    void setUp() {
        JacksonTester.initFields((Object)this, (ObjectMapper)new ObjectMapper());
    }

    @Test
    void marshal_to_json() throws IOException {
        PortableCoordinates portableCoordinates = new PortableCoordinates(BigDecimal.valueOf(0.123454321), BigDecimal.valueOf(-44.444445111));
        Assertions.assertThat((String)this.json.write((Object)portableCoordinates).getJson()).isEqualTo("{\"lat\":0.12345,\"lng\":-44.44445}");
    }

    @Test
    void conversion_from_domain() {
        Coordinates coordinates = Coordinates.valueOf((double)0.04687, (double)-88.8889);
        PortableCoordinates portableCoordinates = PortableCoordinates.fromCoordinates((Coordinates)coordinates);
        Assertions.assertThat((BigDecimal)portableCoordinates.getLatitude()).isEqualTo((Object)coordinates.latitude());
        Assertions.assertThat((BigDecimal)portableCoordinates.getLongitude()).isEqualTo((Object)coordinates.longitude());
        Assertions.assertThatNullPointerException().isThrownBy(() -> PortableCoordinates.fromCoordinates(null)).withMessageContaining("coordinates");
    }

    @Test
    void should_reduce_scale_if_needed() {
        Coordinates coordinates = Coordinates.valueOf((double)0.123450001, (double)-88.999999999);
        Coordinates scaledDown = Coordinates.valueOf((double)0.12345, (double)-89.0);
        PortableCoordinates portableCoordinates = PortableCoordinates.fromCoordinates((Coordinates)coordinates);
        Assertions.assertThat((BigDecimal)portableCoordinates.getLatitude()).isEqualTo((Object)scaledDown.latitude());
        Assertions.assertThat((BigDecimal)portableCoordinates.getLongitude()).isEqualByComparingTo((Comparable)scaledDown.longitude());
    }

    @Test
    void equals_hashCode_toString() {
        BigDecimal lat1 = BigDecimal.valueOf(10.0101);
        BigDecimal lat2 = BigDecimal.valueOf(20.2323);
        BigDecimal lon1 = BigDecimal.valueOf(-8.7);
        BigDecimal lon2 = BigDecimal.valueOf(-7.8);
        PortableCoordinates portableCoordinates = new PortableCoordinates(lat1, lon1);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)portableCoordinates).isNotEqualTo(null)).isNotEqualTo((Object)new Coordinates(lat1, lon1))).isNotEqualTo((Object)new PortableCoordinates(lat1, lon2))).isNotEqualTo((Object)new PortableCoordinates(lat2, lon1))).isEqualTo((Object)portableCoordinates)).isEqualTo((Object)new PortableCoordinates(lat1, lon1))).hasSameHashCodeAs((Object)new PortableCoordinates(lat1, lon1))).asString().contains(new CharSequence[]{lat1.toPlainString(), lon1.toPlainString()});
    }
}

