/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.optaplanner.core.api.solver.ProblemFactChange;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaweb.vehiclerouting.plugin.planner.RouteChangedEventPublisher;
import org.optaweb.vehiclerouting.plugin.planner.change.AddVehicle;
import org.optaweb.vehiclerouting.plugin.planner.change.AddVisit;
import org.optaweb.vehiclerouting.plugin.planner.change.ChangeVehicleCapacity;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVehicle;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;
import org.optaweb.vehiclerouting.service.error.ErrorEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Default
class SolverManager
implements SolverEventListener<VehicleRoutingSolution> {
    private static final Logger logger = LoggerFactory.getLogger(SolverManager.class);
    private final Solver<VehicleRoutingSolution> solver;
    private final ListeningExecutorService executor;
    private final RouteChangedEventPublisher routeChangedEventPublisher;
    private final Event<ErrorEvent> errorEvent;
    private ListenableFuture<VehicleRoutingSolution> solverFuture;

    @Inject
    SolverManager(Solver<VehicleRoutingSolution> solver, ListeningExecutorService executor, RouteChangedEventPublisher routeChangedEventPublisher, Event<ErrorEvent> errorEvent) {
        this.solver = solver;
        this.executor = executor;
        this.routeChangedEventPublisher = routeChangedEventPublisher;
        this.errorEvent = errorEvent;
        this.solver.addEventListener((SolverEventListener)this);
    }

    public void bestSolutionChanged(BestSolutionChangedEvent<VehicleRoutingSolution> bestSolutionChangedEvent) {
        if (!bestSolutionChangedEvent.isEveryProblemFactChangeProcessed()) {
            logger.info("Ignoring a new best solution that has some problem facts missing");
            return;
        }
        this.routeChangedEventPublisher.publishSolution((VehicleRoutingSolution)bestSolutionChangedEvent.getNewBestSolution());
    }

    void startSolver(VehicleRoutingSolution solution) {
        if (this.solverFuture != null) {
            throw new IllegalStateException("Solver start has already been requested");
        }
        this.solverFuture = this.executor.submit(() -> (VehicleRoutingSolution)this.solver.solve((Object)solution));
        this.solverFuture.addListener(() -> {
            if (!this.solver.isTerminateEarly()) {
                try {
                    this.solverFuture.get();
                    logger.error("The solver has stopped without being terminated early so at this point it is expected to have crashed but there was no exception.\nIf you see this other than during test execution it is probably a bug.");
                    this.errorEvent.fire((Object)new ErrorEvent(this, "Solver stopped without being terminated early and without throwing an exception. This is a bug."));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted while retrieving the cause of solver failure", e);
                }
                catch (ExecutionException e) {
                    logger.error("Solver failed", (Throwable)e);
                    this.errorEvent.fire((Object)new ErrorEvent(this, e.toString()));
                }
            }
        }, MoreExecutors.directExecutor());
    }

    void stopSolver() {
        if (this.solverFuture != null) {
            this.solver.terminateEarly();
            try {
                this.solverFuture.get();
                this.solverFuture = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Failed to stop solver", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Failed to stop solver", e.getCause());
            }
        }
    }

    private void assertSolverIsAlive() {
        if (this.solverFuture == null) {
            throw new IllegalStateException("Solver has not started yet");
        }
        if (this.solverFuture.isDone()) {
            try {
                this.solverFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Solver has died", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Solver has died", e.getCause());
            }
            throw new IllegalStateException("Solver has finished solving even though it operates in daemon mode");
        }
    }

    void addVisit(PlanningVisit visit) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChange((ProblemFactChange)new AddVisit(visit));
    }

    void removeVisit(PlanningVisit visit) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChange((ProblemFactChange)new RemoveVisit(visit));
    }

    void addVehicle(PlanningVehicle vehicle) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChange((ProblemFactChange)new AddVehicle(vehicle));
    }

    void removeVehicle(PlanningVehicle vehicle) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChange((ProblemFactChange)new RemoveVehicle(vehicle));
    }

    void changeCapacity(PlanningVehicle vehicle) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChange((ProblemFactChange)new ChangeVehicleCapacity(vehicle));
    }

    static interface SolvingTask
    extends Callable<VehicleRoutingSolution> {
    }
}

