/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleData;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleEntity;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleRepositoryImpl;

@ExtendWith(value={MockitoExtension.class})
class VehicleRepositoryImplTest {
    @Mock
    private VehicleCrudRepository crudRepository;
    @InjectMocks
    private VehicleRepositoryImpl repository;
    @Captor
    private ArgumentCaptor<VehicleEntity> vehicleEntityCaptor;
    private final Vehicle testVehicle = VehicleFactory.createVehicle((long)19L, (String)"vehicle name", (int)1100);

    VehicleRepositoryImplTest() {
    }

    private static VehicleEntity vehicleEntity(Vehicle vehicle) {
        return new VehicleEntity(vehicle.id(), vehicle.name(), vehicle.capacity());
    }

    @Test
    void should_create_vehicle() {
        int savedCapacity = 1;
        Vehicle newVehicle = this.repository.createVehicle(savedCapacity);
        ((VehicleCrudRepository)Mockito.verify((Object)this.crudRepository)).persist((Object)((VehicleEntity)this.vehicleEntityCaptor.capture()));
        VehicleEntity savedVehicle = (VehicleEntity)this.vehicleEntityCaptor.getValue();
        Assertions.assertThat((String)savedVehicle.getName()).isNotNull();
        Assertions.assertThat((int)savedVehicle.getCapacity()).isEqualTo(savedCapacity);
        Assertions.assertThat((String)newVehicle.name()).isNotNull();
        Assertions.assertThat((int)newVehicle.capacity()).isEqualTo(savedCapacity);
    }

    @Test
    void create_vehicle_from_given_data() {
        String name = "x";
        int capacity = 111;
        VehicleData vehicleData = VehicleFactory.vehicleData((String)name, (int)capacity);
        Vehicle newVehicle = this.repository.createVehicle(vehicleData);
        Assertions.assertThat((String)newVehicle.name()).isEqualTo(name);
        Assertions.assertThat((int)newVehicle.capacity()).isEqualTo(capacity);
    }

    @Test
    void remove_created_vehicle_by_id() {
        VehicleEntity vehicleEntity = VehicleRepositoryImplTest.vehicleEntity(this.testVehicle);
        long id = this.testVehicle.id();
        Mockito.when((Object)this.crudRepository.findByIdOptional((Object)id)).thenReturn(Optional.of(vehicleEntity));
        Vehicle removed = this.repository.removeVehicle(id);
        Assertions.assertThat((Object)removed).isEqualTo((Object)this.testVehicle);
        ((VehicleCrudRepository)Mockito.verify((Object)this.crudRepository)).deleteById((Object)id);
    }

    @Test
    void removing_nonexistent_vehicle_should_fail() {
        Mockito.when((Object)this.crudRepository.findByIdOptional((Object)ArgumentMatchers.anyLong())).thenReturn(Optional.empty());
        int uniqueNonexistentId = 7173;
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.repository.removeVehicle((long)uniqueNonexistentId)).withMessageContaining(String.valueOf(uniqueNonexistentId));
    }

    @Test
    void remove_all_vehicles() {
        this.repository.removeAll();
        ((VehicleCrudRepository)Mockito.verify((Object)this.crudRepository)).deleteAll();
    }

    @Test
    void get_all_vehicles() {
        VehicleEntity vehicleEntity = VehicleRepositoryImplTest.vehicleEntity(this.testVehicle);
        Mockito.when((Object)this.crudRepository.streamAll()).thenReturn(Stream.of(vehicleEntity));
        Assertions.assertThat((List)this.repository.vehicles()).containsExactly((Object[])new Vehicle[]{this.testVehicle});
    }

    @Test
    void find_by_id() {
        VehicleEntity vehicleEntity = VehicleRepositoryImplTest.vehicleEntity(this.testVehicle);
        Mockito.when((Object)this.crudRepository.findByIdOptional((Object)this.testVehicle.id())).thenReturn(Optional.of(vehicleEntity));
        Assertions.assertThat((Optional)this.repository.find(this.testVehicle.id())).contains((Object)this.testVehicle);
    }

    @Test
    void update() {
        long vehicleId = 123L;
        String name = "xy";
        int capacity = 80;
        VehicleEntity vehicleEntity = new VehicleEntity(vehicleId, name, capacity - 10);
        Mockito.when((Object)this.crudRepository.findByIdOptional((Object)vehicleId)).thenReturn(Optional.of(vehicleEntity));
        Vehicle vehicle = this.repository.changeCapacity(vehicleId, capacity);
        ((VehicleCrudRepository)Mockito.verify((Object)this.crudRepository)).flush();
        Assertions.assertThat((int)vehicleEntity.getCapacity()).isEqualTo(capacity);
        Assertions.assertThat((long)vehicle.id()).isEqualTo(vehicleId);
        Assertions.assertThat((String)vehicle.name()).isEqualTo(name);
        Assertions.assertThat((int)vehicle.capacity()).isEqualTo(capacity);
    }
}

