/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.RouteChangedEventPublisher;
import org.optaweb.vehiclerouting.plugin.planner.RouteOptimizerImpl;
import org.optaweb.vehiclerouting.plugin.planner.SolverManager;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;
import org.optaweb.vehiclerouting.service.location.DistanceMatrixRow;

@ExtendWith(value={MockitoExtension.class})
class RouteOptimizerImplTest {
    private final DistanceMatrixRow matrixRow = locationId -> Distance.ZERO;
    private final Location location1 = new Location(1L, Coordinates.valueOf((double)1.0, (double)0.1));
    private final Location location2 = new Location(2L, Coordinates.valueOf((double)0.2, (double)2.2));
    private final Location location3 = new Location(3L, Coordinates.valueOf((double)3.4, (double)5.6));
    @Captor
    private ArgumentCaptor<VehicleRoutingSolution> solutionArgumentCaptor;
    @Captor
    private ArgumentCaptor<PlanningVehicle> vehicleArgumentCaptor;
    @Mock
    private SolverManager solverManager;
    @Mock
    private RouteChangedEventPublisher routeChangedEventPublisher;
    @InjectMocks
    private RouteOptimizerImpl routeOptimizer;

    RouteOptimizerImplTest() {
    }

    @Test
    void solution_with_depot_and_no_visits_should_be_published() {
        Object[] vehicleIds = new Long[]{2L, 3L, 5L, 7L, 11L};
        Arrays.stream(vehicleIds).forEach(vehicleId -> this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)vehicleId)));
        Mockito.clearInvocations((Object[])new RouteChangedEventPublisher[]{this.routeChangedEventPublisher});
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.solverManager});
        VehicleRoutingSolution solution = this.verifyPublishingPreliminarySolution();
        Assertions.assertThat((List)solution.getVehicleList()).extracting(PlanningVehicle::getId).containsExactlyInAnyOrder(vehicleIds);
        Assertions.assertThat((List)solution.getDepotList()).extracting(PlanningDepot::getId).containsExactly((Object[])new Long[]{this.location1.id()});
        Assertions.assertThat((List)solution.getVisitList()).isEmpty();
    }

    @Test
    void solution_with_vehicles_and_no_depot_should_be_published() {
        long vehicleId = 7L;
        Vehicle vehicle = VehicleFactory.testVehicle((long)7L);
        this.routeOptimizer.addVehicle(vehicle);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.solverManager});
        VehicleRoutingSolution solutionWithOneVehicle = this.verifyPublishingPreliminarySolution();
        Assertions.assertThat((List)solutionWithOneVehicle.getVehicleList()).extracting(PlanningVehicle::getId).containsExactly((Object[])new Long[]{7L});
        Assertions.assertThat((List)solutionWithOneVehicle.getDepotList()).isEmpty();
        Assertions.assertThat((List)solutionWithOneVehicle.getVisitList()).isEmpty();
        Mockito.clearInvocations((Object[])new RouteChangedEventPublisher[]{this.routeChangedEventPublisher});
        this.routeOptimizer.removeVehicle(vehicle);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.solverManager});
        VehicleRoutingSolution emptySolution = this.verifyPublishingPreliminarySolution();
        Assertions.assertThat((List)emptySolution.getVehicleList()).isEmpty();
        Assertions.assertThat((List)emptySolution.getDepotList()).isEmpty();
        Assertions.assertThat((List)emptySolution.getVisitList()).isEmpty();
    }

    @Test
    void removing_wrong_vehicle_should_fail_fast() {
        long vehicleId = 7L;
        Vehicle vehicle = VehicleFactory.testVehicle((long)7L);
        Vehicle nonExistentVehicle = VehicleFactory.testVehicle((long)8L);
        this.routeOptimizer.addVehicle(vehicle);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.routeOptimizer.removeVehicle(nonExistentVehicle)).withMessageContaining("exist");
    }

    @Test
    void removing_wrong_location_should_fail_fast() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.routeOptimizer.removeLocation(this.location1)).withMessageContaining("no locations");
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.routeOptimizer.removeLocation(this.location3)).withMessageContaining("exist");
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.routeOptimizer.removeLocation(this.location3)).withMessageContaining("exist");
    }

    @Test
    void added_vehicle_should_be_moved_to_the_depot_even_if_solver_is_not_yet_solving() {
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)7L));
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)8L));
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        VehicleRoutingSolution solution = this.verifySolverStartedWithSolution();
        ((ListAssert)Assertions.assertThat((List)solution.getVehicleList()).hasSize(2)).allMatch(vehicle -> vehicle.getDepot().getId() == this.location1.id());
        Assertions.assertThat((List)solution.getDepotList()).isNotEmpty();
        Assertions.assertThat((List)solution.getVisitList()).isNotEmpty();
    }

    @Test
    void solver_should_start_when_vehicle_is_added_and_there_is_at_least_one_visit() {
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.solverManager});
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)9L));
        VehicleRoutingSolution solution = this.verifySolverStartedWithSolution();
        Assertions.assertThat((List)solution.getVehicleList()).hasSize(1);
        Assertions.assertThat((List)solution.getVisitList()).hasSize(1);
    }

    @Test
    void each_location_should_have_a_distance_map_after_it_is_added() {
        long millis = 8079L;
        this.routeOptimizer.addLocation(this.location1, locationId -> Distance.ofMillis((long)millis));
        VehicleRoutingSolution solution = this.verifyPublishingPreliminarySolution();
        Assertions.assertThat((List)solution.getDepotList()).hasSize(1);
        Assertions.assertThat((long)((PlanningDepot)solution.getDepotList().get(0)).getLocation().distanceTo(PlanningLocationFactory.fromDomain((Location)this.location2))).isEqualTo(millis);
    }

    @Test
    void solver_should_start_when_two_locations_added_and_there_is_at_least_one_vehicle() {
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)1L));
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        VehicleRoutingSolution solution = this.verifySolverStartedWithSolution();
        Assertions.assertThat((List)solution.getDepotList()).hasSize(1);
        Assertions.assertThat((long)((PlanningDepot)solution.getDepotList().get(0)).getLocation().getId()).isEqualTo(this.location1.id());
        Assertions.assertThat((List)solution.getVisitList()).hasSize(1);
        Assertions.assertThat((long)((PlanningVisit)solution.getVisitList().get(0)).getLocation().getId()).isEqualTo(this.location2.id());
    }

    @Test
    void solver_should_not_start_nor_stop_when_modifying_location_and_there_are_no_vehicles() {
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        Mockito.clearInvocations((Object[])new RouteChangedEventPublisher[]{this.routeChangedEventPublisher});
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        ((SolverManager)Mockito.verify((Object)this.solverManager, (VerificationMode)Mockito.never())).startSolver((VehicleRoutingSolution)ArgumentMatchers.any());
        VehicleRoutingSolution solution1 = this.verifyPublishingPreliminarySolution();
        Assertions.assertThat((List)solution1.getVehicleList()).isEmpty();
        Assertions.assertThat((List)solution1.getDepotList()).hasSize(1);
        Assertions.assertThat((List)solution1.getVisitList()).hasSize(1);
        this.routeOptimizer.addLocation(this.location3, this.matrixRow);
        Mockito.clearInvocations((Object[])new RouteChangedEventPublisher[]{this.routeChangedEventPublisher});
        this.routeOptimizer.removeLocation(this.location2);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.solverManager});
        VehicleRoutingSolution solution2 = this.verifyPublishingPreliminarySolution();
        Assertions.assertThat((List)solution2.getVehicleList()).isEmpty();
        Assertions.assertThat((List)solution1.getDepotList()).hasSize(1);
        Assertions.assertThat((List)solution1.getVisitList()).hasSize(1);
    }

    @Test
    void solver_should_stop_and_publish_when_last_vehicle_is_removed() {
        Vehicle vehicle = VehicleFactory.testVehicle((long)23L);
        this.routeOptimizer.addVehicle(vehicle);
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).startSolver((VehicleRoutingSolution)ArgumentMatchers.any(VehicleRoutingSolution.class));
        Mockito.clearInvocations((Object[])new RouteChangedEventPublisher[]{this.routeChangedEventPublisher});
        this.routeOptimizer.removeVehicle(vehicle);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).stopSolver();
        VehicleRoutingSolution solution = this.verifyPublishingPreliminarySolution();
        Assertions.assertThat((List)solution.getVehicleList()).isEmpty();
    }

    @Test
    void solver_should_stop_when_locations_reduced_to_one() {
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)0L));
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).startSolver((VehicleRoutingSolution)ArgumentMatchers.any(VehicleRoutingSolution.class));
        Mockito.clearInvocations((Object[])new RouteChangedEventPublisher[]{this.routeChangedEventPublisher});
        this.routeOptimizer.removeLocation(this.location2);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).stopSolver();
        VehicleRoutingSolution solution = this.verifyPublishingPreliminarySolution();
        Assertions.assertThat((List)solution.getVisitList()).isEmpty();
        Assertions.assertThat((List)solution.getDepotList()).hasSize(1);
        Assertions.assertThat((List)solution.getVehicleList()).hasSize(1);
    }

    @Test
    void removing_depot_impossible_when_there_are_other_locations() {
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)0L));
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).startSolver((VehicleRoutingSolution)ArgumentMatchers.any(VehicleRoutingSolution.class));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.routeOptimizer.removeLocation(this.location1)).withMessageContaining("depot");
    }

    @Test
    void when_depot_is_added_all_vehicles_should_be_moved_to_it() {
        long vehicleId1 = 8L;
        long vehicleId2 = 113L;
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)vehicleId1));
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)vehicleId2));
        Mockito.clearInvocations((Object[])new RouteChangedEventPublisher[]{this.routeChangedEventPublisher});
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        VehicleRoutingSolution solution1 = this.verifyPublishingPreliminarySolution();
        Assertions.assertThat((List)solution1.getVehicleList()).extracting(PlanningVehicle::getId).containsExactlyInAnyOrder((Object[])new Long[]{vehicleId1, vehicleId2});
        Assertions.assertThat((List)solution1.getVehicleList()).allMatch(vehicle -> vehicle.getDepot().getId() == this.location1.id());
        Assertions.assertThat((List)solution1.getDepotList()).extracting(PlanningDepot::getId).containsExactly((Object[])new Long[]{this.location1.id()});
        Mockito.clearInvocations((Object[])new RouteChangedEventPublisher[]{this.routeChangedEventPublisher});
        this.routeOptimizer.removeLocation(this.location1);
        VehicleRoutingSolution solution2 = this.verifyPublishingPreliminarySolution();
        Assertions.assertThat((List)solution2.getVehicleList()).extracting(PlanningVehicle::getId).containsExactlyInAnyOrder((Object[])new Long[]{vehicleId1, vehicleId2});
        Assertions.assertThat((List)solution2.getDepotList()).isEmpty();
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
    }

    @Test
    void adding_location_to_running_solver_must_happen_through_problem_fact_change() {
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)55L));
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).startSolver((VehicleRoutingSolution)ArgumentMatchers.any(VehicleRoutingSolution.class));
        this.routeOptimizer.addLocation(this.location3, this.matrixRow);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).addVisit((PlanningVisit)ArgumentMatchers.any(PlanningVisit.class));
    }

    @Test
    void removing_location_from_solver_with_more_than_two_locations_must_happen_through_problem_fact_change() {
        long vehicleId = 0L;
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)vehicleId));
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).startSolver((VehicleRoutingSolution)ArgumentMatchers.any(VehicleRoutingSolution.class));
        this.routeOptimizer.addLocation(this.location3, this.matrixRow);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).addVisit((PlanningVisit)ArgumentMatchers.any(PlanningVisit.class));
        this.routeOptimizer.removeLocation(this.location2);
        ArgumentCaptor visitArgumentCaptor = ArgumentCaptor.forClass(PlanningVisit.class);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).removeVisit((PlanningVisit)visitArgumentCaptor.capture());
        Assertions.assertThat((long)((PlanningVisit)visitArgumentCaptor.getValue()).getId()).isEqualTo(this.location2.id());
        ((SolverManager)Mockito.verify((Object)this.solverManager, (VerificationMode)Mockito.never())).stopSolver();
    }

    @Test
    void adding_vehicle_to_running_solver_must_happen_through_problem_fact_change() {
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)1L));
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).startSolver((VehicleRoutingSolution)ArgumentMatchers.any(VehicleRoutingSolution.class));
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)22L));
        ((SolverManager)Mockito.verify((Object)this.solverManager)).addVehicle((PlanningVehicle)this.vehicleArgumentCaptor.capture());
        PlanningVehicle vehicle = (PlanningVehicle)this.vehicleArgumentCaptor.getValue();
        Assertions.assertThat((long)vehicle.getDepot().getId()).isEqualTo(this.location1.id());
    }

    @Test
    void removing_vehicle_from_running_solver_with_more_than_one_vehicle_must_happen_through_problem_fact_change() {
        long vehicleId1 = 10L;
        long vehicleId2 = 20L;
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)10L));
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)20L));
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).startSolver((VehicleRoutingSolution)ArgumentMatchers.any(VehicleRoutingSolution.class));
        this.routeOptimizer.removeVehicle(VehicleFactory.testVehicle((long)10L));
        ((SolverManager)Mockito.verify((Object)this.solverManager)).removeVehicle((PlanningVehicle)ArgumentMatchers.any(PlanningVehicle.class));
        ((SolverManager)Mockito.verify((Object)this.solverManager, (VerificationMode)Mockito.never())).stopSolver();
    }

    @Test
    void changing_vehicle_capacity_should_take_effect_when_solver_is_started_or_be_published() {
        long vehicleId = 1L;
        int oldCapacity = 7;
        int newCapacity = 12;
        Vehicle vehicle = VehicleFactory.createVehicle((long)1L, (String)"", (int)7);
        this.routeOptimizer.addVehicle(vehicle);
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        Mockito.clearInvocations((Object[])new RouteChangedEventPublisher[]{this.routeChangedEventPublisher});
        this.routeOptimizer.changeCapacity(VehicleFactory.createVehicle((long)1L, (String)"", (int)12));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.solverManager});
        VehicleRoutingSolution preliminarySolution = this.verifyPublishingPreliminarySolution();
        Assertions.assertThat((int)((PlanningVehicle)preliminarySolution.getVehicleList().get(0)).getCapacity()).isEqualTo(12);
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        VehicleRoutingSolution solution = this.verifySolverStartedWithSolution();
        Assertions.assertThat((int)((PlanningVehicle)solution.getVehicleList().get(0)).getCapacity()).isEqualTo(12);
    }

    @Test
    void changing_vehicle_capacity_must_happen_through_problem_fact_change_when_solver_is_running() {
        int capacity = 14816;
        long vehicleId = 10L;
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)10L));
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).startSolver((VehicleRoutingSolution)ArgumentMatchers.any(VehicleRoutingSolution.class));
        this.routeOptimizer.changeCapacity(VehicleFactory.createVehicle((long)10L, (String)"", (int)14816));
        ((SolverManager)Mockito.verify((Object)this.solverManager)).changeCapacity((PlanningVehicle)ArgumentMatchers.any(PlanningVehicle.class));
    }

    @Test
    void changing_vehicle_capacity_must_fail_fast_if_the_vehicle_does_not_exist() {
        long vehicleId = 10L;
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)10L));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.routeOptimizer.changeCapacity(VehicleFactory.testVehicle((long)11L))).withMessageContaining("exist");
    }

    @Test
    void remove_all_locations_should_stop_solver_and_publish_preliminary_solution() {
        long vehicleId = 10L;
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)vehicleId));
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).startSolver((VehicleRoutingSolution)ArgumentMatchers.any(VehicleRoutingSolution.class));
        this.routeOptimizer.addLocation(this.location3, this.matrixRow);
        Mockito.clearInvocations((Object[])new RouteChangedEventPublisher[]{this.routeChangedEventPublisher});
        this.routeOptimizer.removeAllLocations();
        ((SolverManager)Mockito.verify((Object)this.solverManager)).stopSolver();
        VehicleRoutingSolution solution = this.verifyPublishingPreliminarySolution();
        Assertions.assertThat((List)solution.getVehicleList()).hasSize(1);
        Assertions.assertThat((List)solution.getDepotList()).isEmpty();
        Assertions.assertThat((List)solution.getVisitList()).isEmpty();
    }

    @Test
    void remove_all_vehicles_should_stop_solver_and_publish_preliminary_solution() {
        long vehicleId = 10L;
        this.routeOptimizer.addVehicle(VehicleFactory.testVehicle((long)vehicleId));
        this.routeOptimizer.addLocation(this.location1, this.matrixRow);
        this.routeOptimizer.addLocation(this.location2, this.matrixRow);
        ((SolverManager)Mockito.verify((Object)this.solverManager)).startSolver((VehicleRoutingSolution)ArgumentMatchers.any(VehicleRoutingSolution.class));
        this.routeOptimizer.addLocation(this.location3, this.matrixRow);
        Mockito.clearInvocations((Object[])new RouteChangedEventPublisher[]{this.routeChangedEventPublisher});
        this.routeOptimizer.removeAllVehicles();
        ((SolverManager)Mockito.verify((Object)this.solverManager)).stopSolver();
        VehicleRoutingSolution solution = this.verifyPublishingPreliminarySolution();
        Assertions.assertThat((List)solution.getVehicleList()).isEmpty();
        Assertions.assertThat((List)solution.getDepotList()).hasSize(1);
        Assertions.assertThat((List)solution.getVisitList()).hasSize(2);
    }

    @Test
    void removing_all_locations_should_not_fail_when_solver_is_not_solving() {
        Assertions.assertThatCode(() -> this.routeOptimizer.removeAllLocations()).doesNotThrowAnyException();
    }

    @Test
    void removing_all_vehicles_should_not_fail_when_solver_is_not_solving() {
        Assertions.assertThatCode(() -> this.routeOptimizer.removeAllVehicles()).doesNotThrowAnyException();
    }

    private VehicleRoutingSolution verifyPublishingPreliminarySolution() {
        ((RouteChangedEventPublisher)Mockito.verify((Object)this.routeChangedEventPublisher)).publishSolution((VehicleRoutingSolution)this.solutionArgumentCaptor.capture());
        return (VehicleRoutingSolution)this.solutionArgumentCaptor.getValue();
    }

    private VehicleRoutingSolution verifySolverStartedWithSolution() {
        ((SolverManager)Mockito.verify((Object)this.solverManager)).startSolver((VehicleRoutingSolution)this.solutionArgumentCaptor.capture());
        return (VehicleRoutingSolution)this.solutionArgumentCaptor.getValue();
    }
}

