/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.routing;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.plugin.routing.AirDistanceRouter;
import org.optaweb.vehiclerouting.service.region.BoundingBox;

class AirDistanceRouterTest {
    AirDistanceRouterTest() {
    }

    @Test
    void travel_time_should_be_distance_divided_by_speed() {
        AirDistanceRouter router = new AirDistanceRouter();
        Coordinates from = Coordinates.valueOf((double)0.0, (double)0.0);
        Coordinates to = Coordinates.valueOf((double)3.0, (double)4.0);
        long travelTimeMillis = router.travelTimeMillis(from, to);
        Assertions.assertThat((long)travelTimeMillis).isEqualTo((long)(9.25 * (double)AirDistanceRouter.MILLIS_IN_ONE_HOUR));
    }

    @Test
    void bounding_box_is_the_whole_globe() {
        BoundingBox bounds = new AirDistanceRouter().getBounds();
        Assertions.assertThat((Object)bounds.getSouthWest()).isEqualTo((Object)Coordinates.valueOf((double)-90.0, (double)-180.0));
        Assertions.assertThat((Object)bounds.getNorthEast()).isEqualTo((Object)Coordinates.valueOf((double)90.0, (double)180.0));
    }

    @Test
    void path_from_a_to_b_should_be_the_line_ab() {
        AirDistanceRouter router = new AirDistanceRouter();
        Coordinates from = Coordinates.valueOf((double)0.0, (double)0.0);
        Coordinates to = Coordinates.valueOf((double)3.0, (double)4.0);
        Assertions.assertThat((List)router.getPath(from, to)).containsExactly((Object[])new Coordinates[]{from, to});
    }
}

