/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.persistence.LocationCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.LocationEntity;
import org.optaweb.vehiclerouting.plugin.persistence.LocationRepositoryImpl;

@ExtendWith(value={MockitoExtension.class})
class LocationRepositoryImplTest {
    @Mock
    private LocationCrudRepository crudRepository;
    @InjectMocks
    private LocationRepositoryImpl repository;
    @Captor
    private ArgumentCaptor<LocationEntity> locationEntityCaptor;
    private final Location testLocation = new Location(76L, Coordinates.valueOf((double)1.2, (double)3.4), "description");

    LocationRepositoryImplTest() {
    }

    private static LocationEntity locationEntity(Location location) {
        return new LocationEntity(location.id(), location.coordinates().latitude(), location.coordinates().longitude(), location.description());
    }

    @Test
    void should_create_location_and_generate_id() {
        LocationEntity newEntity = LocationRepositoryImplTest.locationEntity(this.testLocation);
        Mockito.when((Object)((LocationEntity)this.crudRepository.save((Object)((LocationEntity)this.locationEntityCaptor.capture())))).thenReturn((Object)newEntity);
        Coordinates savedCoordinates = Coordinates.valueOf((double)0.00213, (double)32.777);
        String savedDescription = "new location";
        Location newLocation = this.repository.createLocation(savedCoordinates, savedDescription);
        LocationEntity savedLocation = (LocationEntity)this.locationEntityCaptor.getValue();
        Assertions.assertThat((BigDecimal)savedLocation.getLatitude()).isEqualTo((Object)savedCoordinates.latitude());
        Assertions.assertThat((BigDecimal)savedLocation.getLongitude()).isEqualTo((Object)savedCoordinates.longitude());
        Assertions.assertThat((String)savedLocation.getDescription()).isEqualTo(savedDescription);
        Assertions.assertThat((long)newLocation.id()).isEqualTo(newEntity.getId());
        Assertions.assertThat((Object)newLocation.coordinates()).isEqualTo((Object)new Coordinates(newEntity.getLatitude(), newEntity.getLongitude()));
        Assertions.assertThat((String)newLocation.description()).isEqualTo(newEntity.getDescription());
    }

    @Test
    void remove_created_location_by_id() {
        LocationEntity locationEntity = LocationRepositoryImplTest.locationEntity(this.testLocation);
        long id = this.testLocation.id();
        Mockito.when((Object)this.crudRepository.findById((Object)id)).thenReturn(Optional.of(locationEntity));
        Location removed = this.repository.removeLocation(id);
        Assertions.assertThat((Object)removed).isEqualTo((Object)this.testLocation);
        ((LocationCrudRepository)Mockito.verify((Object)this.crudRepository)).deleteById((Object)id);
    }

    @Test
    void removing_nonexistent_location_should_fail() {
        Mockito.when((Object)this.crudRepository.findById((Object)ArgumentMatchers.anyLong())).thenReturn(Optional.empty());
        int uniqueNonexistentId = 7173;
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.repository.removeLocation((long)uniqueNonexistentId)).withMessageContaining(String.valueOf(uniqueNonexistentId));
    }

    @Test
    void remove_all_locations() {
        this.repository.removeAll();
        ((LocationCrudRepository)Mockito.verify((Object)this.crudRepository)).deleteAll();
    }

    @Test
    void get_all_locations() {
        LocationEntity locationEntity = LocationRepositoryImplTest.locationEntity(this.testLocation);
        Mockito.when((Object)this.crudRepository.findAll()).thenReturn(Collections.singletonList(locationEntity));
        Assertions.assertThat((List)this.repository.locations()).containsExactly((Object[])new Location[]{this.testLocation});
    }

    @Test
    void find_by_id() {
        LocationEntity locationEntity = LocationRepositoryImplTest.locationEntity(this.testLocation);
        Mockito.when((Object)this.crudRepository.findById((Object)this.testLocation.id())).thenReturn(Optional.of(locationEntity));
        Assertions.assertThat((Optional)this.repository.find(this.testLocation.id())).contains((Object)this.testLocation);
    }
}

