/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleData;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleEntity;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleRepositoryImpl;

@ExtendWith(value={MockitoExtension.class})
class VehicleRepositoryImplTest {
    @Mock
    private VehicleCrudRepository crudRepository;
    @InjectMocks
    private VehicleRepositoryImpl repository;
    @Captor
    private ArgumentCaptor<VehicleEntity> vehicleEntityCaptor;
    private final Vehicle testVehicle = VehicleFactory.createVehicle((long)19L, (String)"vehicle name", (int)1100);

    VehicleRepositoryImplTest() {
    }

    private static VehicleEntity vehicleEntity(Vehicle vehicle) {
        return new VehicleEntity(vehicle.id(), vehicle.name(), vehicle.capacity());
    }

    @Test
    void should_create_vehicle_and_generate_id_and_name() {
        VehicleEntity newEntity = VehicleRepositoryImplTest.vehicleEntity(this.testVehicle);
        Mockito.when((Object)((VehicleEntity)this.crudRepository.save((Object)((VehicleEntity)this.vehicleEntityCaptor.capture())))).thenReturn((Object)newEntity);
        int savedCapacity = 1;
        Vehicle newVehicle = this.repository.createVehicle(savedCapacity);
        List savedVehicles = this.vehicleEntityCaptor.getAllValues();
        Assertions.assertThat((List)savedVehicles).hasSize(2);
        Assertions.assertThat((String)((VehicleEntity)savedVehicles.get(0)).getName()).isNull();
        Assertions.assertThat((int)((VehicleEntity)savedVehicles.get(0)).getCapacity()).isEqualTo(savedCapacity);
        Assertions.assertThat((String)((VehicleEntity)savedVehicles.get(1)).getName()).isEqualTo("Vehicle " + newEntity.getId());
        Assertions.assertThat((int)((VehicleEntity)savedVehicles.get(1)).getCapacity()).isEqualTo(savedCapacity);
        Assertions.assertThat((long)newVehicle.id()).isEqualTo(newEntity.getId());
        Assertions.assertThat((String)newVehicle.name()).isEqualTo(newEntity.getName());
        Assertions.assertThat((int)newVehicle.capacity()).isEqualTo(newEntity.getCapacity());
    }

    @Test
    void create_vehicle_from_given_data() {
        VehicleEntity newEntity = VehicleRepositoryImplTest.vehicleEntity(this.testVehicle);
        Mockito.when((Object)((VehicleEntity)this.crudRepository.save((Object)((VehicleEntity)this.vehicleEntityCaptor.capture())))).thenReturn((Object)newEntity);
        VehicleData vehicleData = VehicleFactory.vehicleData((String)"x", (int)1);
        Vehicle newVehicle = this.repository.createVehicle(vehicleData);
        VehicleEntity savedVehicle = (VehicleEntity)this.vehicleEntityCaptor.getValue();
        Assertions.assertThat((String)savedVehicle.getName()).isEqualTo(vehicleData.name());
        Assertions.assertThat((int)savedVehicle.getCapacity()).isEqualTo(vehicleData.capacity());
        Assertions.assertThat((long)newVehicle.id()).isEqualTo(newEntity.getId());
        Assertions.assertThat((String)newVehicle.name()).isEqualTo(newEntity.getName());
        Assertions.assertThat((int)newVehicle.capacity()).isEqualTo(newEntity.getCapacity());
    }

    @Test
    void remove_created_vehicle_by_id() {
        VehicleEntity vehicleEntity = VehicleRepositoryImplTest.vehicleEntity(this.testVehicle);
        long id = this.testVehicle.id();
        Mockito.when((Object)this.crudRepository.findById((Object)id)).thenReturn(Optional.of(vehicleEntity));
        Vehicle removed = this.repository.removeVehicle(id);
        Assertions.assertThat((Object)removed).isEqualTo((Object)this.testVehicle);
        ((VehicleCrudRepository)Mockito.verify((Object)this.crudRepository)).deleteById((Object)id);
    }

    @Test
    void removing_nonexistent_vehicle_should_fail() {
        Mockito.when((Object)this.crudRepository.findById((Object)ArgumentMatchers.anyLong())).thenReturn(Optional.empty());
        int uniqueNonexistentId = 7173;
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.repository.removeVehicle((long)uniqueNonexistentId)).withMessageContaining(String.valueOf(uniqueNonexistentId));
    }

    @Test
    void remove_all_vehicles() {
        this.repository.removeAll();
        ((VehicleCrudRepository)Mockito.verify((Object)this.crudRepository)).deleteAll();
    }

    @Test
    void get_all_vehicles() {
        VehicleEntity vehicleEntity = VehicleRepositoryImplTest.vehicleEntity(this.testVehicle);
        Mockito.when((Object)this.crudRepository.findAll()).thenReturn(Collections.singletonList(vehicleEntity));
        Assertions.assertThat((List)this.repository.vehicles()).containsExactly((Object[])new Vehicle[]{this.testVehicle});
    }

    @Test
    void find_by_id() {
        VehicleEntity vehicleEntity = VehicleRepositoryImplTest.vehicleEntity(this.testVehicle);
        Mockito.when((Object)this.crudRepository.findById((Object)this.testVehicle.id())).thenReturn(Optional.of(vehicleEntity));
        Assertions.assertThat((Optional)this.repository.find(this.testVehicle.id())).contains((Object)this.testVehicle);
    }

    @Test
    void update() {
        this.repository.update(this.testVehicle);
        ((VehicleCrudRepository)Mockito.verify((Object)this.crudRepository)).save((Object)((VehicleEntity)this.vehicleEntityCaptor.capture()));
        VehicleEntity savedVehicle = (VehicleEntity)this.vehicleEntityCaptor.getValue();
        Assertions.assertThat((long)savedVehicle.getId()).isEqualTo(this.testVehicle.id());
        Assertions.assertThat((String)savedVehicle.getName()).isEqualTo(this.testVehicle.name());
        Assertions.assertThat((int)savedVehicle.getCapacity()).isEqualTo(this.testVehicle.capacity());
    }
}

