/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.ArrayList;
import java.util.Objects;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

public class RemoveLocation
implements ProblemFactChange<VehicleRoutingSolution> {
    private final PlanningLocation removedLocation;

    public RemoveLocation(PlanningLocation removedLocation) {
        this.removedLocation = Objects.requireNonNull(removedLocation);
    }

    public void doChange(ScoreDirector<VehicleRoutingSolution> scoreDirector) {
        VehicleRoutingSolution workingSolution = (VehicleRoutingSolution)scoreDirector.getWorkingSolution();
        PlanningLocation workingLocation = (PlanningLocation)scoreDirector.lookUpWorkingObject((Object)this.removedLocation);
        if (workingLocation == null) {
            throw new IllegalStateException("Can't look up a working copy of " + this.removedLocation);
        }
        workingSolution.setLocationList(new ArrayList(workingSolution.getLocationList()));
        scoreDirector.beforeProblemFactRemoved((Object)workingLocation);
        if (!workingSolution.getLocationList().remove(workingLocation)) {
            throw new IllegalStateException("Working solution's locationList " + workingSolution.getLocationList() + " doesn't contain the workingLocation (" + workingLocation + "). This is a bug!");
        }
        scoreDirector.afterProblemFactRemoved((Object)workingLocation);
        scoreDirector.triggerVariableListeners();
    }
}

