/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.vehicle;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.service.vehicle.VehicleRepository;
import org.springframework.stereotype.Component;

@Component
public class VehicleRepositoryImpl
implements VehicleRepository {
    private long idSequence = 0L;
    private Map<Long, Vehicle> vehicles = new HashMap(10);

    public Vehicle createVehicle(String name, int capacity) {
        Vehicle vehicle = VehicleFactory.createVehicle((long)this.idSequence++, (String)name, (int)capacity);
        this.vehicles.put(vehicle.id(), vehicle);
        return vehicle;
    }

    public List<Vehicle> vehicles() {
        return Collections.unmodifiableList(this.vehicles.values().stream().sorted((o1, o2) -> Long.signum(o2.id() - o1.id())).collect(Collectors.toList()));
    }

    public Vehicle removeVehicle(long id) {
        return (Vehicle)this.vehicles.remove(id);
    }

    public void removeAll() {
        this.vehicles.clear();
    }

    public Optional<Vehicle> find(Long vehicleId) {
        return Optional.ofNullable(this.vehicles.get(vehicleId));
    }

    public long nextId() {
        return this.idSequence;
    }

    public void update(Vehicle vehicle) {
        this.vehicles.put(vehicle.id(), vehicle);
    }
}

