/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.Objects;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

public class RemoveVehicle
implements ProblemFactChange<VehicleRoutingSolution> {
    private final PlanningVehicle removedVehicle;

    public RemoveVehicle(PlanningVehicle removedVehicle) {
        this.removedVehicle = Objects.requireNonNull(removedVehicle);
    }

    public void doChange(ScoreDirector<VehicleRoutingSolution> scoreDirector) {
        VehicleRoutingSolution workingSolution = (VehicleRoutingSolution)scoreDirector.getWorkingSolution();
        PlanningVehicle workingVehicle = (PlanningVehicle)scoreDirector.lookUpWorkingObject((Object)this.removedVehicle);
        if (workingVehicle == null) {
            throw new IllegalStateException("Can't look up a working copy of " + this.removedVehicle);
        }
        for (PlanningVisit visit : workingVehicle.getFutureVisits()) {
            scoreDirector.beforeVariableChanged((Object)visit, "previousStandstill");
            visit.setPreviousStandstill(null);
            scoreDirector.afterVariableChanged((Object)visit, "previousStandstill");
        }
        scoreDirector.beforeProblemFactRemoved((Object)workingVehicle);
        if (!workingSolution.getVehicleList().remove(workingVehicle)) {
            throw new IllegalStateException("Working solution's vehicleList " + workingSolution.getVehicleList() + " doesn't contain the workingVehicle (" + workingVehicle + "). This is a bug!");
        }
        scoreDirector.afterProblemFactRemoved((Object)workingVehicle);
        scoreDirector.triggerVariableListeners();
    }
}

