/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.domain;

import java.text.NumberFormat;
import java.util.List;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.drools.ProblemFactCollectionProperty;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.persistable.AbstractPersistable;

@PlanningSolution
public class VehicleRoutingSolution
extends AbstractPersistable {
    protected String name;
    private String distanceUnitOfMeasurement;
    private List<PlanningLocation> locationList;
    private List<PlanningDepot> depotList;
    private List<PlanningVehicle> vehicleList;
    private List<PlanningVisit> visitList;
    private HardSoftLongScore score;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDistanceUnitOfMeasurement() {
        return this.distanceUnitOfMeasurement;
    }

    public void setDistanceUnitOfMeasurement(String distanceUnitOfMeasurement) {
        this.distanceUnitOfMeasurement = distanceUnitOfMeasurement;
    }

    @ProblemFactCollectionProperty
    public List<PlanningLocation> getLocationList() {
        return this.locationList;
    }

    public void setLocationList(List<PlanningLocation> locationList) {
        this.locationList = locationList;
    }

    @ProblemFactCollectionProperty
    public List<PlanningDepot> getDepotList() {
        return this.depotList;
    }

    public void setDepotList(List<PlanningDepot> depotList) {
        this.depotList = depotList;
    }

    @PlanningEntityCollectionProperty
    @ValueRangeProvider(id="vehicleRange")
    public List<PlanningVehicle> getVehicleList() {
        return this.vehicleList;
    }

    public void setVehicleList(List<PlanningVehicle> vehicleList) {
        this.vehicleList = vehicleList;
    }

    @PlanningEntityCollectionProperty
    @ValueRangeProvider(id="visitRange")
    public List<PlanningVisit> getVisitList() {
        return this.visitList;
    }

    public void setVisitList(List<PlanningVisit> visitList) {
        this.visitList = visitList;
    }

    @PlanningScore
    public HardSoftLongScore getScore() {
        return this.score;
    }

    public void setScore(HardSoftLongScore score) {
        this.score = score;
    }

    public String getDistanceString(NumberFormat numberFormat) {
        if (this.score == null) {
            return null;
        }
        long distance = -this.score.getSoftScore();
        if (this.distanceUnitOfMeasurement == null) {
            return numberFormat.format((double)distance / 1000.0);
        }
        switch (this.distanceUnitOfMeasurement) {
            case "sec": {
                long hours = distance / 3600000L;
                long minutes = distance % 3600000L / 60000L;
                long seconds = distance % 60000L / 1000L;
                long milliseconds = distance % 1000L;
                return hours + "h " + minutes + "m " + seconds + "s " + milliseconds + "ms";
            }
            case "meter": {
                long km = distance / 1000L;
                long meter = distance % 1000L;
                return km + "km " + meter + "m";
            }
        }
        return numberFormat.format((double)distance / 1000.0) + " " + this.distanceUnitOfMeasurement;
    }

    public String toString() {
        return "VehicleRoutingSolution{name='" + this.name + '\'' + ", distanceUnitOfMeasurement='" + this.distanceUnitOfMeasurement + '\'' + ", locationList=" + this.locationList + ", depotList=" + this.depotList + ", vehicleList=" + this.vehicleList + ", visitList=" + this.visitList + ", score=" + this.score + ", id=" + this.id + '}';
    }
}

