/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.location;

import java.util.Objects;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.optaweb.vehiclerouting.service.location.DistanceMatrixRow;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.location.RouteOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocationService {
    private static final Logger logger = LoggerFactory.getLogger(LocationService.class);
    private final LocationRepository repository;
    private final RouteOptimizer optimizer;
    private final DistanceMatrix distanceMatrix;

    @Autowired
    LocationService(LocationRepository repository, RouteOptimizer optimizer, DistanceMatrix distanceMatrix) {
        this.repository = repository;
        this.optimizer = optimizer;
        this.distanceMatrix = distanceMatrix;
    }

    public synchronized boolean createLocation(Coordinates coordinates, String description) {
        Objects.requireNonNull(coordinates);
        Objects.requireNonNull(description);
        return this.submitToPlanner(this.repository.createLocation(coordinates, description));
    }

    public synchronized boolean addLocation(Location location) {
        return this.submitToPlanner(Objects.requireNonNull(location));
    }

    private boolean submitToPlanner(Location location) {
        try {
            DistanceMatrixRow distanceMatrixRow = this.distanceMatrix.addLocation(location);
            this.optimizer.addLocation(location, distanceMatrixRow);
        }
        catch (Exception e) {
            logger.warn("Failed to calculate distances for {}, it will be discarded", (Object)location);
            logger.debug("Details:", (Throwable)e);
            this.repository.removeLocation(location.id());
            return false;
        }
        return true;
    }

    public synchronized void removeLocation(long id) {
        Location location = this.repository.removeLocation(id);
        this.optimizer.removeLocation(location);
    }

    public synchronized void removeAll() {
        this.optimizer.removeAllLocations();
        this.repository.removeAll();
        this.distanceMatrix.clear();
    }
}

