/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.vehicle;

import java.util.Optional;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.service.location.RouteOptimizer;
import org.optaweb.vehiclerouting.service.vehicle.VehicleRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VehicleService {
    static final int DEFAULT_VEHICLE_CAPACITY = 10;
    private final RouteOptimizer optimizer;
    private final VehicleRepository vehicleRepository;

    @Autowired
    public VehicleService(RouteOptimizer optimizer, VehicleRepository vehicleRepository) {
        this.optimizer = optimizer;
        this.vehicleRepository = vehicleRepository;
    }

    public void addVehicle() {
        long id = this.vehicleRepository.nextId();
        Vehicle vehicle = this.vehicleRepository.createVehicle("Vehicle " + id, 10);
        this.optimizer.addVehicle(vehicle);
    }

    public void removeVehicle(long vehicleId) {
        Vehicle vehicle = this.vehicleRepository.removeVehicle(vehicleId);
        this.optimizer.removeVehicle(vehicle);
    }

    public synchronized void removeAnyVehicle() {
        Optional first = this.vehicleRepository.vehicles().stream().min((o1, o2) -> (int)(o1.id() - o2.id()));
        first.ifPresent(vehicle -> {
            Vehicle removed = this.vehicleRepository.removeVehicle(vehicle.id());
            this.optimizer.removeVehicle(removed);
        });
    }

    public void removeAll() {
        this.optimizer.removeAllVehicles();
        this.vehicleRepository.removeAll();
    }

    public void changeCapacity(Long vehicleId, int capacity) {
        Vehicle vehicle = (Vehicle)this.vehicleRepository.find(vehicleId).orElseThrow(() -> new IllegalArgumentException("Can't remove Vehicle{id=" + vehicleId + "} because it doesn't exist"));
        Vehicle updatedVehicle = VehicleFactory.createVehicle((long)vehicle.id(), (String)vehicle.name(), (int)capacity);
        this.vehicleRepository.update(updatedVehicle);
        this.optimizer.changeCapacity(updatedVehicle);
    }
}

