/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { Action } from 'redux';
import { LatLng } from '../route/types';

export enum ActionType {
  SERVER_INFO = 'SERVER_INFO',
}

export interface ServerInfoAction extends Action<ActionType.SERVER_INFO> {
  value: ServerInfo;
}

export interface Demo {
  name: string;
  visits: number;
}

export interface ServerInfo {
  boundingBox: [LatLng, LatLng] | null;
  countryCodes: string[];
  demos: Demo[];
}
