/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import org.optaweb.vehiclerouting.domain.Distance;

public class PortableDistance {
    @JsonValue
    private final String distance;

    static PortableDistance fromDistance(Distance distance) {
        long seconds = (Objects.requireNonNull(distance).millis() + 500L) / 1000L;
        return new PortableDistance(String.format("%dh %dm %ds", seconds / 3600L, seconds / 60L % 60L, seconds % 60L));
    }

    private PortableDistance(String distance) {
        this.distance = distance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortableDistance that = (PortableDistance)o;
        return this.distance.equals(that.distance);
    }

    public int hashCode() {
        return Objects.hash(this.distance);
    }

    public String toString() {
        return "PortableDistance{distance='" + this.distance + '\'' + '}';
    }
}

