/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.demo;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.optaweb.vehiclerouting.domain.RoutingProblem;

class RoutingProblemList {
    private final Map<String, RoutingProblem> routingProblems;

    RoutingProblemList(List<RoutingProblem> routingProblems) {
        this.routingProblems = Objects.requireNonNull(routingProblems).stream().collect(Collectors.toMap(RoutingProblem::name, Function.identity()));
    }

    Collection<RoutingProblem> all() {
        return this.routingProblems.values();
    }

    RoutingProblem byName(String name) {
        RoutingProblem routingProblem = (RoutingProblem)this.routingProblems.get(name);
        if (routingProblem == null) {
            throw new IllegalArgumentException("Data set with name '" + name + "' doesn't exist");
        }
        return routingProblem;
    }
}

