/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.route;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.service.route.ShallowRoute;
import org.springframework.context.ApplicationEvent;

public class RouteChangedEvent
extends ApplicationEvent {
    private final Distance distance;
    private final List<Long> vehicleIds;
    private final Long depotId;
    private final List<Long> visitIds;
    private final Collection<ShallowRoute> routes;

    public RouteChangedEvent(Object source, Distance distance, List<Long> vehicleIds, Long depotId, List<Long> visitIds, Collection<ShallowRoute> routes) {
        super(source);
        this.distance = Objects.requireNonNull(distance);
        this.vehicleIds = Objects.requireNonNull(vehicleIds);
        this.depotId = depotId;
        this.visitIds = Objects.requireNonNull(visitIds);
        this.routes = Objects.requireNonNull(routes);
    }

    public List<Long> vehicleIds() {
        return this.vehicleIds;
    }

    public Collection<ShallowRoute> routes() {
        return this.routes;
    }

    public Distance distance() {
        return this.distance;
    }

    public Optional<Long> depotId() {
        return Optional.ofNullable(this.depotId);
    }

    public List<Long> visitIds() {
        return this.visitIds;
    }
}

