/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.util.Optional;

@ConfigGroup
public class HibernateOrmRuntimeConfigPersistenceUnit {
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitDatabase database = new HibernateOrmConfigPersistenceUnitDatabase();
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitScripts scripts = new HibernateOrmConfigPersistenceUnitScripts();
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitLog log = new HibernateOrmConfigPersistenceUnitLog();

    public boolean isAnyPropertySet() {
        return this.database.isAnyPropertySet() || this.scripts.isAnyPropertySet() || this.log.isAnyPropertySet();
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitLog {
        @ConfigItem
        public boolean sql = false;
        @ConfigItem(defaultValue="true")
        public boolean formatSql = true;
        @ConfigItem(defaultValueDocumentation="depends on dialect")
        public Optional<Boolean> jdbcWarnings = Optional.empty();

        public boolean isAnyPropertySet() {
            return this.sql || !this.formatSql || this.jdbcWarnings.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitScriptGeneration {
        @ConfigItem(name="<<parent>>", defaultValue="none")
        public String generation = "none";
        @ConfigItem
        public Optional<String> createTarget = Optional.empty();
        @ConfigItem
        public Optional<String> dropTarget = Optional.empty();

        public boolean isAnyPropertySet() {
            return !"none".equals(this.generation) || this.createTarget.isPresent() || this.dropTarget.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitDatabaseGeneration {
        @ConfigItem(name="<<parent>>", defaultValue="none")
        public String generation = "none";
        @ConfigItem
        public boolean createSchemas = false;
        @ConfigItem
        public boolean haltOnError = false;

        public boolean isAnyPropertySet() {
            return !"none".equals(this.generation) || this.createSchemas || this.haltOnError;
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitScripts {
        @ConfigItem
        public HibernateOrmConfigPersistenceUnitScriptGeneration generation = new HibernateOrmConfigPersistenceUnitScriptGeneration();

        public boolean isAnyPropertySet() {
            return this.generation.isAnyPropertySet();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitDatabase {
        @ConfigItem
        public HibernateOrmConfigPersistenceUnitDatabaseGeneration generation = new HibernateOrmConfigPersistenceUnitDatabaseGeneration();

        public boolean isAnyPropertySet() {
            return this.generation.isAnyPropertySet();
        }
    }
}

