/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.Tuple;

abstract class AbstractAccumulator<ResultContainer_, Result_>
implements Accumulator {
    private final Supplier<ResultContainer_> containerSupplier;
    private final Function<ResultContainer_, Result_> finisher;

    protected AbstractAccumulator(Supplier<ResultContainer_> containerSupplier, Function<ResultContainer_, Result_> finisher) {
        this.containerSupplier = Objects.requireNonNull(containerSupplier);
        this.finisher = Objects.requireNonNull(finisher);
    }

    protected static <Value_> Value_ extractValue(Declaration declaration, int offset, Tuple leftTuple) {
        Tuple tuple = AbstractAccumulator.getTuple(offset, leftTuple);
        return (Value_)declaration.getValue(null, tuple.getFactHandle().getObject());
    }

    protected static int findTupleOffset(Declaration declaration, Tuple tuple) {
        int offset = 0;
        while (tuple.getIndex() != declaration.getTupleIndex()) {
            tuple = tuple.getParent();
            ++offset;
        }
        return offset;
    }

    protected static Tuple getTuple(int deltaOffset, Tuple tuple) {
        switch (deltaOffset) {
            case 0: {
                return tuple;
            }
            case 1: {
                return tuple.getParent();
            }
            case 2: {
                return tuple.getParent().getParent();
            }
            case 3: {
                return tuple.getParent().getParent().getParent();
            }
        }
        throw new UnsupportedOperationException("Impossible state: tuple delta offset (" + deltaOffset + ").");
    }

    public final Object createWorkingMemoryContext() {
        return null;
    }

    public final Object createContext() {
        return null;
    }

    public final ResultContainer_ init(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) {
        return this.containerSupplier.get();
    }

    public final boolean supportsReverse() {
        return true;
    }

    public final boolean tryReverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Object value, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) {
        ((Runnable)value).run();
        return true;
    }

    public Result_ getResult(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) {
        return this.finisher.apply(context);
    }
}

