/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

public class EncodedValueOld {
    protected final long shift;
    protected final long mask;
    protected final double factor;
    protected final long defaultValue;
    private final String name;
    private final long maxValue;
    private final boolean allowZero;
    private final int bits;

    public EncodedValueOld(String name, int shift, int bits, double factor, long defaultValue, int maxValue) {
        this(name, shift, bits, factor, defaultValue, maxValue, true);
    }

    public EncodedValueOld(String name, int shift, int bits, double factor, long defaultValue, int maxValue, boolean allowZero) {
        this.name = name;
        this.shift = shift;
        this.factor = factor;
        this.defaultValue = defaultValue;
        this.bits = bits;
        long tmpMask = (1L << bits) - 1L;
        this.maxValue = Math.min((long)maxValue, Math.round((double)tmpMask * factor));
        if ((long)maxValue > this.maxValue) {
            throw new IllegalStateException(name + " -> maxValue " + maxValue + " is too large for " + bits + " bits");
        }
        double factorDivision = (double)maxValue / factor;
        if (factorDivision != (double)((int)factorDivision)) {
            throw new IllegalStateException("MaxValue needs to be divisible by factor without remainder");
        }
        this.mask = tmpMask << shift;
        this.allowZero = allowZero;
    }

    protected void checkValue(long value) {
        if (value > this.maxValue) {
            throw new IllegalArgumentException(this.name + " value too large for encoding: " + value + ", maxValue:" + this.maxValue);
        }
        if (value < 0L) {
            throw new IllegalArgumentException("negative " + this.name + " value not allowed! " + value);
        }
        if (!this.allowZero && value == 0L) {
            throw new IllegalArgumentException("zero " + this.name + " value not allowed! " + value);
        }
    }

    public long setValue(long flags, long value) {
        value = Math.round((double)value / this.factor);
        this.checkValue((long)((double)value * this.factor));
        return (flags &= this.mask ^ 0xFFFFFFFFFFFFFFFFL) | (value <<= (int)this.shift);
    }

    public String getName() {
        return this.name;
    }

    public long getValue(long flags) {
        flags &= this.mask;
        return Math.round((double)(flags >>>= (int)this.shift) * this.factor);
    }

    public int getBits() {
        return this.bits;
    }

    public double getFactor() {
        return this.factor;
    }

    public long setDefaultValue(long flags) {
        return this.setValue(flags, this.defaultValue);
    }
}

