/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.util.TurnCostEncoder;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.TurnCostExtension;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;

public class TurnWeighting
implements Weighting {
    private final TurnCostEncoder turnCostEncoder;
    private final TurnCostExtension turnCostExt;
    private final Weighting superWeighting;
    private final double uTurnCost;

    public TurnWeighting(Weighting superWeighting, TurnCostExtension turnCostExt) {
        this(superWeighting, turnCostExt, Double.POSITIVE_INFINITY);
    }

    public TurnWeighting(Weighting superWeighting, TurnCostExtension turnCostExt, double uTurnCost) {
        this.turnCostEncoder = superWeighting.getFlagEncoder();
        this.superWeighting = superWeighting;
        this.turnCostExt = turnCostExt;
        this.uTurnCost = uTurnCost;
        if (turnCostExt == null) {
            throw new RuntimeException("No storage set to calculate turn weight");
        }
    }

    public double getUTurnCost() {
        return this.uTurnCost;
    }

    @Override
    public double getMinWeight(double distance) {
        return this.superWeighting.getMinWeight(distance);
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        double weight = this.superWeighting.calcWeight(edgeState, reverse, prevOrNextEdgeId);
        if (!EdgeIterator.Edge.isValid(prevOrNextEdgeId)) {
            return weight;
        }
        int origEdgeId = reverse ? edgeState.getOrigEdgeLast() : edgeState.getOrigEdgeFirst();
        double turnCosts = reverse ? this.calcTurnWeight(origEdgeId, edgeState.getBaseNode(), prevOrNextEdgeId) : this.calcTurnWeight(prevOrNextEdgeId, edgeState.getBaseNode(), origEdgeId);
        return weight + turnCosts;
    }

    @Override
    public long calcMillis(EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        long millis = this.superWeighting.calcMillis(edgeState, reverse, prevOrNextEdgeId);
        if (!EdgeIterator.Edge.isValid(prevOrNextEdgeId)) {
            return millis;
        }
        int origEdgeId = edgeState.getEdge();
        long turnCostsInSeconds = (long)(reverse ? this.calcTurnWeight(origEdgeId, edgeState.getBaseNode(), prevOrNextEdgeId) : this.calcTurnWeight(prevOrNextEdgeId, edgeState.getBaseNode(), origEdgeId));
        return millis + 1000L * turnCostsInSeconds;
    }

    public double calcTurnWeight(int edgeFrom, int nodeVia, int edgeTo) {
        if (!EdgeIterator.Edge.isValid(edgeFrom) || !EdgeIterator.Edge.isValid(edgeTo)) {
            return 0.0;
        }
        if (this.turnCostExt.isUTurn(edgeFrom, edgeTo)) {
            return this.uTurnCost;
        }
        long turnFlags = this.turnCostExt.getTurnCostFlags(edgeFrom, nodeVia, edgeTo);
        if (this.turnCostEncoder.isTurnRestricted(turnFlags)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.turnCostEncoder.getTurnCost(turnFlags);
    }

    @Override
    public FlagEncoder getFlagEncoder() {
        return this.superWeighting.getFlagEncoder();
    }

    @Override
    public boolean matches(HintsMap weightingMap) {
        return this.superWeighting.matches(weightingMap);
    }

    public String toString() {
        return "turn|" + this.superWeighting.toString();
    }

    @Override
    public String getName() {
        return "turn|" + this.superWeighting.getName();
    }
}

