/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor;

import java.util.Arrays;
import java.util.List;
import org.optaplanner.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.Acceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public class CompositeAcceptor<Solution_>
extends AbstractAcceptor<Solution_> {
    protected final List<Acceptor<Solution_>> acceptorList;

    public CompositeAcceptor(List<Acceptor<Solution_>> acceptorList) {
        this.acceptorList = acceptorList;
    }

    public CompositeAcceptor(Acceptor<Solution_> ... acceptors) {
        this(Arrays.asList(acceptors));
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        for (Acceptor<Solution_> acceptor : this.acceptorList) {
            acceptor.solvingStarted(solverScope);
        }
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        for (Acceptor<Solution_> acceptor : this.acceptorList) {
            acceptor.phaseStarted(phaseScope);
        }
    }

    @Override
    public void stepStarted(LocalSearchStepScope<Solution_> stepScope) {
        for (Acceptor<Solution_> acceptor : this.acceptorList) {
            acceptor.stepStarted(stepScope);
        }
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope<Solution_> moveScope) {
        for (Acceptor<Solution_> acceptor : this.acceptorList) {
            boolean accepted = acceptor.isAccepted(moveScope);
            if (accepted) continue;
            return false;
        }
        return true;
    }

    @Override
    public void stepEnded(LocalSearchStepScope<Solution_> stepScope) {
        for (Acceptor<Solution_> acceptor : this.acceptorList) {
            acceptor.stepEnded(stepScope);
        }
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        for (Acceptor<Solution_> acceptor : this.acceptorList) {
            acceptor.phaseEnded(phaseScope);
        }
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        for (Acceptor<Solution_> acceptor : this.acceptorList) {
            acceptor.solvingEnded(solverScope);
        }
    }
}

