/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.phase.custom;

import java.util.ArrayList;
import org.optaplanner.core.config.phase.custom.CustomPhaseConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.phase.AbstractPhaseFactory;
import org.optaplanner.core.impl.phase.custom.CustomPhase;
import org.optaplanner.core.impl.phase.custom.CustomPhaseCommand;
import org.optaplanner.core.impl.phase.custom.DefaultCustomPhase;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.termination.Termination;

public class DefaultCustomPhaseFactory<Solution_>
extends AbstractPhaseFactory<Solution_, CustomPhaseConfig> {
    public DefaultCustomPhaseFactory(CustomPhaseConfig phaseConfig) {
        super(phaseConfig);
    }

    @Override
    public CustomPhase<Solution_> buildPhase(int phaseIndex, HeuristicConfigPolicy<Solution_> solverConfigPolicy, BestSolutionRecaller<Solution_> bestSolutionRecaller, Termination<Solution_> solverTermination) {
        HeuristicConfigPolicy<Solution_> phaseConfigPolicy = solverConfigPolicy.createPhaseConfigPolicy();
        DefaultCustomPhase phase = new DefaultCustomPhase(phaseIndex, solverConfigPolicy.getLogIndentation(), this.buildPhaseTermination(phaseConfigPolicy, solverTermination));
        if (ConfigUtils.isEmptyCollection(((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandClassList()) && ConfigUtils.isEmptyCollection(((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandList())) {
            throw new IllegalArgumentException("Configure at least 1 <customPhaseCommandClass> in the <customPhase> configuration.");
        }
        ArrayList customPhaseCommandList_ = new ArrayList(this.getCustomPhaseCommandListSize());
        if (((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandClassList() != null) {
            for (Class<? extends CustomPhaseCommand> customPhaseCommandClass : ((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandClassList()) {
                customPhaseCommandList_.add(this.createCustomPhaseCommand(customPhaseCommandClass));
            }
        }
        if (((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandList() != null) {
            customPhaseCommandList_.addAll(((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandList());
        }
        phase.setCustomPhaseCommandList(customPhaseCommandList_);
        EnvironmentMode environmentMode = phaseConfigPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            phase.setAssertStepScoreFromScratch(true);
        }
        return phase;
    }

    private CustomPhaseCommand<Solution_> createCustomPhaseCommand(Class<? extends CustomPhaseCommand> customPhaseCommandClass) {
        CustomPhaseCommand customPhaseCommand = ConfigUtils.newInstance(this.phaseConfig, "customPhaseCommandClass", customPhaseCommandClass);
        ConfigUtils.applyCustomProperties(customPhaseCommand, "customPhaseCommandClass", ((CustomPhaseConfig)this.phaseConfig).getCustomProperties(), "customProperties");
        return customPhaseCommand;
    }

    private int getCustomPhaseCommandListSize() {
        return (((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandClassList() == null ? 0 : ((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandClassList().size()) + (((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandList() == null ? 0 : ((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandList().size());
    }
}

