/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.stream;

import java.util.Collection;
import java.util.Map;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirector;
import org.optaplanner.core.impl.score.director.stream.DroolsConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.stream.drools.SessionDescriptor;

public final class DroolsConstraintStreamScoreDirector<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirector<Solution_, Score_, DroolsConstraintStreamScoreDirectorFactory<Solution_, Score_>> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    protected KieSession session;
    protected AgendaFilter agendaFilter;
    protected ScoreInliner<Score_> scoreInliner;

    public DroolsConstraintStreamScoreDirector(DroolsConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory, boolean lookUpEnabled, boolean constraintMatchEnabledPreference) {
        super(scoreDirectorFactory, lookUpEnabled, constraintMatchEnabledPreference);
        this.solutionDescriptor = scoreDirectorFactory.getSolutionDescriptor();
    }

    @Override
    public void setWorkingSolution(Solution_ workingSolution) {
        super.setWorkingSolution(workingSolution);
        this.resetConstraintStreamingSession();
    }

    private void resetConstraintStreamingSession() {
        if (this.session != null) {
            this.session.dispose();
        }
        SessionDescriptor sessionDescriptor = ((DroolsConstraintStreamScoreDirectorFactory)this.scoreDirectorFactory).newConstraintStreamingSession(this.constraintMatchEnabledPreference, this.workingSolution);
        this.session = sessionDescriptor.getSession();
        this.agendaFilter = sessionDescriptor.getAgendaFilter();
        this.scoreInliner = sessionDescriptor.getScoreInliner();
        Collection<Object> workingFacts = this.getSolutionDescriptor().getAllFacts(this.workingSolution);
        for (Object fact : workingFacts) {
            this.session.insert(fact);
        }
    }

    @Override
    public Score_ calculateScore() {
        this.variableListenerSupport.assertNotificationQueuesAreEmpty();
        this.session.fireAllRules(this.agendaFilter);
        Score_ score = this.scoreInliner.extractScore(this.workingInitScore);
        this.setCalculatedScore(score);
        return score;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return this.constraintMatchEnabledPreference;
    }

    @Override
    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        if (this.workingSolution == null) {
            throw new IllegalStateException("The method setWorkingSolution() must be called before the method getConstraintMatchTotalMap().");
        }
        this.session.fireAllRules(this.agendaFilter);
        return this.scoreInliner.getConstraintMatchTotalMap();
    }

    @Override
    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        if (this.workingSolution == null) {
            throw new IllegalStateException("The method setWorkingSolution() must be called before the method getIndictmentMap().");
        }
        this.session.fireAllRules(this.agendaFilter);
        return this.scoreInliner.getIndictmentMap();
    }

    @Override
    public void close() {
        super.close();
        this.session.dispose();
        this.session = null;
        this.agendaFilter = null;
        this.scoreInliner = null;
    }

    @Override
    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") cannot be added to the ScoreDirector.");
        }
        if (!this.getSolutionDescriptor().hasEntityDescriptor(entity.getClass())) {
            throw new IllegalArgumentException("The entity (" + entity + ") of class (" + entity.getClass() + ") is not a configured @" + PlanningEntity.class.getSimpleName() + ".");
        }
        this.session.insert(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        this.update(entity);
        super.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.retract(entity);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        if (problemFact == null) {
            throw new IllegalArgumentException("The problemFact (" + problemFact + ") cannot be added to the ScoreDirector.");
        }
        this.session.insert(problemFact);
        super.afterProblemFactAdded(problemFact);
    }

    @Override
    public void afterProblemPropertyChanged(Object problemFactOrEntity) {
        this.update(problemFactOrEntity);
        super.afterProblemPropertyChanged(problemFactOrEntity);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.retract(problemFact);
        super.afterProblemFactRemoved(problemFact);
    }

    private void update(Object fact) {
        FactHandle factHandle = this.session.getFactHandle(fact);
        if (factHandle == null) {
            throw new IllegalArgumentException("The fact (" + fact + ") was never added to this ScoreDirector.\nMaybe that specific instance is not in the return values of the " + PlanningSolution.class.getSimpleName() + "'s entity members (" + this.solutionDescriptor.getEntityMemberAndEntityCollectionMemberNames() + ") or fact members (" + this.solutionDescriptor.getProblemFactMemberAndProblemFactCollectionMemberNames() + ").");
        }
        this.session.update(factHandle, fact);
    }

    private void retract(Object fact) {
        FactHandle factHandle = this.session.getFactHandle(fact);
        this.session.delete(factHandle);
    }
}

