/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm.conditional;

import com.graphhopper.util.Helper;
import java.util.Calendar;

public class ParsedCalendar {
    public final ParseType parseType;
    public final Calendar parsedCalendar;

    public ParsedCalendar(ParseType parseType, Calendar parsedCalendar) {
        this.parseType = parseType;
        this.parsedCalendar = parsedCalendar;
    }

    public boolean isYearless() {
        return this.parseType == ParseType.MONTH || this.parseType == ParseType.MONTH_DAY;
    }

    public boolean isDayless() {
        return this.parseType == ParseType.MONTH || this.parseType == ParseType.YEAR_MONTH;
    }

    public boolean isDayOnly() {
        return this.parseType == ParseType.DAY;
    }

    public Calendar getMax() {
        if (this.isDayless()) {
            this.parsedCalendar.set(5, this.parsedCalendar.getActualMaximum(5));
        }
        this.parsedCalendar.set(11, this.parsedCalendar.getActualMaximum(11));
        this.parsedCalendar.set(12, this.parsedCalendar.getActualMaximum(12));
        this.parsedCalendar.set(13, this.parsedCalendar.getActualMaximum(13));
        this.parsedCalendar.set(14, this.parsedCalendar.getActualMaximum(14));
        return this.parsedCalendar;
    }

    public Calendar getMin() {
        if (this.isDayless()) {
            this.parsedCalendar.set(5, this.parsedCalendar.getActualMinimum(5));
        }
        this.parsedCalendar.set(11, this.parsedCalendar.getActualMinimum(11));
        this.parsedCalendar.set(12, this.parsedCalendar.getActualMinimum(12));
        this.parsedCalendar.set(13, this.parsedCalendar.getActualMinimum(13));
        this.parsedCalendar.set(14, this.parsedCalendar.getActualMinimum(14));
        return this.parsedCalendar;
    }

    public String toString() {
        return (Object)((Object)this.parseType) + "; " + Helper.createFormatter().format(this.parsedCalendar.getTime());
    }

    public static enum ParseType {
        YEAR_MONTH_DAY,
        YEAR_MONTH,
        MONTH_DAY,
        MONTH,
        DAY;

    }
}

