/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EncodedValueLookup;
import com.graphhopper.routing.profiles.MaxHeight;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.OSMMaxWidthParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.List;

public class OSMMaxHeightParser
implements TagParser {
    private final DecimalEncodedValue heightEncoder;
    private final boolean enableLog;

    public OSMMaxHeightParser() {
        this(MaxHeight.create(), false);
    }

    public OSMMaxHeightParser(DecimalEncodedValue heightEncoder, boolean enableLog) {
        this.heightEncoder = heightEncoder;
        this.enableLog = enableLog;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        registerNewEncodedValue.add(this.heightEncoder);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access access, long relationFlags) {
        List<String> heightTags = Arrays.asList("maxheight", "maxheight:physical");
        OSMMaxWidthParser.extractMeter(edgeFlags, way, this.heightEncoder, heightTags, this.enableLog);
        return edgeFlags;
    }
}

