/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EncodedValueLookup;
import com.graphhopper.routing.profiles.MaxSpeed;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.shapes.GHPoint;
import java.util.List;

public class OSMMaxSpeedParser
implements TagParser {
    private final DecimalEncodedValue carMaxSpeedEnc;

    public OSMMaxSpeedParser() {
        this(MaxSpeed.create());
    }

    public OSMMaxSpeedParser(DecimalEncodedValue carMaxSpeedEnc) {
        if (!carMaxSpeedEnc.isStoreTwoDirections()) {
            throw new IllegalArgumentException("EncodedValue for maxSpeed must be able to store two directions");
        }
        this.carMaxSpeedEnc = carMaxSpeedEnc;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> list) {
        list.add(this.carMaxSpeedEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access access, long relationFlags) {
        double bwdSpeed;
        double maxPossibleSpeed;
        double fwdSpeed;
        double maxSpeed = AbstractFlagEncoder.parseSpeed(way.getTag("maxspeed"));
        if (maxSpeed < 0.0) {
            GHPoint estmCentre = way.getTag("estimated_center", null);
            SpatialRule spatialRule = way.getTag("spatial_rule", null);
            if (estmCentre != null && spatialRule != null) {
                maxSpeed = spatialRule.getMaxSpeed(way.getTag("highway", ""), maxSpeed);
            }
        }
        if ((fwdSpeed = AbstractFlagEncoder.parseSpeed(way.getTag("maxspeed:forward"))) < 0.0 && maxSpeed > 0.0) {
            fwdSpeed = maxSpeed;
        }
        if (fwdSpeed > (maxPossibleSpeed = 150.0)) {
            fwdSpeed = maxPossibleSpeed;
        }
        if ((bwdSpeed = AbstractFlagEncoder.parseSpeed(way.getTag("maxspeed:backward"))) < 0.0 && maxSpeed > 0.0) {
            bwdSpeed = maxSpeed;
        }
        if (bwdSpeed > maxPossibleSpeed) {
            bwdSpeed = maxPossibleSpeed;
        }
        if (fwdSpeed <= 0.0) {
            fwdSpeed = Double.POSITIVE_INFINITY;
        }
        this.carMaxSpeedEnc.setDecimal(false, edgeFlags, fwdSpeed);
        if (bwdSpeed <= 0.0) {
            bwdSpeed = Double.POSITIVE_INFINITY;
        }
        this.carMaxSpeedEnc.setDecimal(true, edgeFlags, bwdSpeed);
        return edgeFlags;
    }
}

