/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EncodedValueLookup;
import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.RoadAccess;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.TransportationMode;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.List;

public class OSMRoadAccessParser
implements TagParser {
    private final EnumEncodedValue<RoadAccess> roadAccessEnc = new EnumEncodedValue<RoadAccess>("road_access", RoadAccess.class);
    private final List<String> restrictions;

    public OSMRoadAccessParser() {
        this(Arrays.asList("motorcar", "motor_vehicle", "vehicle", "access"));
    }

    public OSMRoadAccessParser(List<String> restrictions) {
        this.restrictions = restrictions;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> list) {
        list.add(this.roadAccessEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay readerWay, EncodingManager.Access access, long relationFlags) {
        SpatialRule spatialRule;
        RoadAccess accessValue = RoadAccess.YES;
        for (String restriction : this.restrictions) {
            RoadAccess tmpAccessValue = RoadAccess.find(readerWay.getTag(restriction, "yes"));
            if (tmpAccessValue == null || tmpAccessValue.ordinal() <= accessValue.ordinal()) continue;
            accessValue = tmpAccessValue;
        }
        if (accessValue == RoadAccess.YES && (spatialRule = (SpatialRule)readerWay.getTag("spatial_rule", null)) != null) {
            accessValue = spatialRule.getAccess(readerWay.getTag("highway", ""), TransportationMode.MOTOR_VEHICLE, RoadAccess.YES);
        }
        this.roadAccessEnc.setEnum(false, edgeFlags, accessValue);
        return edgeFlags;
    }
}

