/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EncodedValueLookup;
import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.RoadClass;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.List;

public class OSMRoadClassParser
implements TagParser {
    private final EnumEncodedValue<RoadClass> roadClassEnc = new EnumEncodedValue<RoadClass>("road_class", RoadClass.class);

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> link) {
        link.add(this.roadClassEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay readerWay, EncodingManager.Access access, long relationFlags) {
        if (!access.isWay()) {
            return edgeFlags;
        }
        String roadClassTag = readerWay.getTag("highway");
        if (roadClassTag == null) {
            return edgeFlags;
        }
        RoadClass roadClass = RoadClass.find(roadClassTag);
        if (roadClass == RoadClass.OTHER && roadClassTag.endsWith("_link")) {
            roadClass = RoadClass.find(roadClassTag.substring(0, roadClassTag.length() - 5));
        }
        if (roadClass != RoadClass.OTHER) {
            this.roadClassEnc.setEnum(false, edgeFlags, roadClass);
        }
        return edgeFlags;
    }
}

