/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.CHGraphImpl;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphExtension;
import com.graphhopper.storage.GraphStorage;
import com.graphhopper.storage.InternalGraphEventListener;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.shapes.BBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class GraphHopperStorage
implements GraphStorage,
Graph {
    private final Directory dir;
    private final EncodingManager encodingManager;
    private final StorableProperties properties;
    private final BaseGraph baseGraph;
    private final Collection<CHGraphImpl> nodeBasedCHGraphs = new ArrayList<CHGraphImpl>(5);
    private final Collection<CHGraphImpl> edgeBasedCHGraphs = new ArrayList<CHGraphImpl>(5);

    public GraphHopperStorage(Directory dir, EncodingManager encodingManager, boolean withElevation, GraphExtension extendedStorage) {
        this(Collections.emptyList(), Collections.emptyList(), dir, encodingManager, withElevation, extendedStorage);
    }

    public GraphHopperStorage(List<? extends Weighting> nodeBasedCHWeightings, Directory dir, EncodingManager encodingManager, boolean withElevation, GraphExtension extendedStorage) {
        this(nodeBasedCHWeightings, Collections.emptyList(), dir, encodingManager, withElevation, extendedStorage);
    }

    public GraphHopperStorage(List<? extends Weighting> nodeBasedCHWeightings, List<? extends Weighting> edgeBasedCHWeightings, Directory dir, EncodingManager encodingManager, boolean withElevation, GraphExtension extendedStorage) {
        if (extendedStorage == null) {
            throw new IllegalArgumentException("GraphExtension cannot be null, use NoOpExtension");
        }
        if (encodingManager == null) {
            throw new IllegalArgumentException("EncodingManager needs to be non-null since 0.7. Create one using EncodingManager.create or EncodingManager.create(flagEncoderFactory, ghLocation)");
        }
        this.encodingManager = encodingManager;
        this.dir = dir;
        this.properties = new StorableProperties(dir);
        InternalGraphEventListener listener = new InternalGraphEventListener(){

            @Override
            public void initStorage() {
                for (CHGraphImpl cg : GraphHopperStorage.this.getAllCHGraphs()) {
                    cg.initStorage();
                }
            }

            @Override
            public void freeze() {
                for (CHGraphImpl cg : GraphHopperStorage.this.getAllCHGraphs()) {
                    cg._prepareForContraction();
                }
            }
        };
        this.baseGraph = new BaseGraph(dir, encodingManager, withElevation, listener, extendedStorage);
        for (Weighting weighting : nodeBasedCHWeightings) {
            this.nodeBasedCHGraphs.add(new CHGraphImpl(weighting, dir, this.baseGraph, false));
        }
        for (Weighting weighting : edgeBasedCHWeightings) {
            this.edgeBasedCHGraphs.add(new CHGraphImpl(weighting, dir, this.baseGraph, true));
        }
    }

    public <T extends Graph> T getGraph(Class<T> clazz, Weighting weighting) {
        if (clazz.equals(Graph.class)) {
            return (T)this.baseGraph;
        }
        Collection<CHGraphImpl> chGraphs = this.getAllCHGraphs();
        if (chGraphs.isEmpty()) {
            throw new IllegalStateException("Cannot find graph implementation for " + clazz);
        }
        if (weighting == null) {
            throw new IllegalStateException("Cannot find CHGraph with null weighting");
        }
        ArrayList<Weighting> existing = new ArrayList<Weighting>();
        for (CHGraphImpl cg : chGraphs) {
            if (cg.getWeighting() == weighting) {
                return (T)cg;
            }
            existing.add(cg.getWeighting());
        }
        throw new IllegalStateException("Cannot find CHGraph for specified weighting: " + weighting + ", existing:" + existing);
    }

    public <T extends Graph> T getGraph(Class<T> clazz) {
        if (clazz.equals(Graph.class)) {
            return (T)this.baseGraph;
        }
        Collection<CHGraphImpl> chGraphs = this.getAllCHGraphs();
        if (chGraphs.isEmpty()) {
            throw new IllegalStateException("Cannot find graph implementation for " + clazz);
        }
        CHGraph cg = chGraphs.iterator().next();
        return (T)cg;
    }

    public boolean isCHPossible() {
        return !this.getAllCHGraphs().isEmpty();
    }

    public List<Weighting> getNodeBasedCHWeightings() {
        return this.getWeightingsFromGraphs(this.nodeBasedCHGraphs);
    }

    public List<Weighting> getEdgeBasedCHWeightings() {
        return this.getWeightingsFromGraphs(this.edgeBasedCHGraphs);
    }

    private List<Weighting> getWeightingsFromGraphs(Collection<CHGraphImpl> graphs) {
        ArrayList<Weighting> list = new ArrayList<Weighting>(graphs.size());
        for (CHGraphImpl cg : graphs) {
            list.add(cg.getWeighting());
        }
        return list;
    }

    @Override
    public Directory getDirectory() {
        return this.dir;
    }

    @Override
    public void setSegmentSize(int bytes) {
        this.baseGraph.setSegmentSize(bytes);
        for (CHGraphImpl cg : this.getAllCHGraphs()) {
            cg.setSegmentSize(bytes);
        }
    }

    @Override
    public GraphHopperStorage create(long byteCount) {
        this.baseGraph.checkInit();
        if (this.encodingManager == null) {
            throw new IllegalStateException("EncodingManager can only be null if you call loadExisting");
        }
        this.dir.create();
        long initSize = Math.max(byteCount, 100L);
        this.properties.create(100L);
        this.properties.put("graph.bytes_for_flags", this.encodingManager.getBytesForFlags());
        this.properties.put("graph.encoded_values", this.encodingManager.toEncodedValuesAsString());
        this.properties.put("graph.flag_encoders", this.encodingManager.toFlagEncodersAsString());
        this.properties.put("graph.byte_order", this.dir.getByteOrder());
        this.properties.put("graph.dimension", this.baseGraph.nodeAccess.getDimension());
        this.properties.putCurrentVersions();
        this.baseGraph.create(initSize);
        for (CHGraphImpl cg : this.getAllCHGraphs()) {
            cg.create(byteCount);
        }
        this.properties.put("graph.ch.weightings", this.getNodeBasedCHWeightings().toString());
        this.properties.put("graph.ch.edge.weightings", this.getEdgeBasedCHWeightings().toString());
        return this;
    }

    @Override
    public EncodingManager getEncodingManager() {
        return this.encodingManager;
    }

    @Override
    public StorableProperties getProperties() {
        return this.properties;
    }

    public void setAdditionalEdgeField(long edgePointer, int value) {
        this.baseGraph.setAdditionalEdgeField(edgePointer, value);
    }

    @Override
    public void markNodeRemoved(int index) {
        this.baseGraph.getRemovedNodes().add(index);
    }

    @Override
    public boolean isNodeRemoved(int index) {
        return this.baseGraph.getRemovedNodes().contains(index);
    }

    @Override
    public void optimize() {
        if (this.isFrozen()) {
            throw new IllegalStateException("do not optimize after graph was frozen");
        }
        int delNodes = this.baseGraph.getRemovedNodes().getCardinality();
        if (delNodes <= 0) {
            return;
        }
        this.baseGraph.inPlaceNodeRemove(delNodes);
        this.baseGraph.trimToSize();
    }

    @Override
    public boolean loadExisting() {
        this.baseGraph.checkInit();
        if (this.properties.loadExisting()) {
            this.properties.checkVersions(false);
            String flagEncodersStr = this.properties.get("graph.flag_encoders");
            if (!this.encodingManager.toFlagEncodersAsString().equalsIgnoreCase(flagEncodersStr)) {
                throw new IllegalStateException("Encoding does not match:\nGraphhopper config: " + this.encodingManager.toFlagEncodersAsString() + "\nGraph: " + flagEncodersStr + "\nChange configuration to match the graph or delete " + this.dir.getLocation());
            }
            String encodedValueStr = this.properties.get("graph.encoded_values");
            if (!this.encodingManager.toEncodedValuesAsString().equalsIgnoreCase(encodedValueStr)) {
                throw new IllegalStateException("Encoded values do not match:\nGraphhopper config: " + this.encodingManager.toEncodedValuesAsString() + "\nGraph: " + encodedValueStr + "\nChange configuration to match the graph or delete " + this.dir.getLocation());
            }
            String byteOrder = this.properties.get("graph.byte_order");
            if (!byteOrder.equalsIgnoreCase("" + this.dir.getByteOrder())) {
                throw new IllegalStateException("Configured graph.byte_order (" + this.dir.getByteOrder() + ") is not equal to loaded " + byteOrder + "");
            }
            String bytesForFlags = this.properties.get("graph.bytes_for_flags");
            if (!bytesForFlags.equalsIgnoreCase("" + this.encodingManager.getBytesForFlags())) {
                throw new IllegalStateException("Configured graph.bytes_for_flags (" + this.encodingManager.getBytesForFlags() + ") is not equal to loaded " + bytesForFlags);
            }
            String dim = this.properties.get("graph.dimension");
            this.baseGraph.loadExisting(dim);
            this.checkIfConfiguredAndLoadedWeightingsCompatible();
            for (CHGraphImpl cg : this.getAllCHGraphs()) {
                if (cg.loadExisting()) continue;
                throw new IllegalStateException("Cannot load " + cg);
            }
            return true;
        }
        return false;
    }

    private void checkIfConfiguredAndLoadedWeightingsCompatible() {
        String loadedStrNode = this.properties.get("graph.ch.weightings");
        List<String> loadedNode = this.parseList(loadedStrNode);
        String loadedStrEdge = this.properties.get("graph.ch.edge.weightings");
        List<String> loadedEdge = this.parseList(loadedStrEdge);
        List<Weighting> configuredNode = this.getNodeBasedCHWeightings();
        List<Weighting> configuredEdge = this.getEdgeBasedCHWeightings();
        if (configuredNode.isEmpty() && configuredEdge.isEmpty() && (!loadedNode.isEmpty() || !loadedEdge.isEmpty())) {
            throw new IllegalStateException("You loaded a CH graph, but you did not specify graph.ch.weightings");
        }
        for (Weighting w : configuredNode) {
            if (loadedNode.contains(w.toString())) continue;
            throw new IllegalStateException("Configured weighting: " + w.toString() + " is not contained in loaded weightings for CH" + loadedStrNode + ".\nYou configured graph.ch.weightings: " + configuredNode);
        }
        for (Weighting w : configuredEdge) {
            if (loadedEdge.contains(w.toString())) continue;
            throw new IllegalStateException("Configured weighting: " + w.toString() + " is not contained in loaded weightings for edge-based CH" + loadedStrEdge + ".\nYou configured graph.ch.edge.weightings: " + configuredEdge);
        }
    }

    private List<String> parseList(String listStr) {
        String trimmed = listStr.trim();
        String[] items = trimmed.substring(1, trimmed.length() - 1).split(",");
        ArrayList<String> result = new ArrayList<String>();
        for (String item : items) {
            String s = item.trim();
            if (s.isEmpty()) continue;
            result.add(s);
        }
        return result;
    }

    @Override
    public void flush() {
        for (CHGraphImpl cg : this.getAllCHGraphs()) {
            cg.setNodesHeader();
            cg.setEdgesHeader();
            cg.flush();
        }
        this.baseGraph.flush();
        this.properties.flush();
    }

    @Override
    public void close() {
        this.properties.close();
        this.baseGraph.close();
        for (CHGraphImpl cg : this.getAllCHGraphs()) {
            cg.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.baseGraph.nodes.isClosed();
    }

    @Override
    public long getCapacity() {
        long cnt = this.baseGraph.getCapacity() + this.properties.getCapacity();
        for (CHGraphImpl cg : this.getAllCHGraphs()) {
            cnt += cg.getCapacity();
        }
        return cnt;
    }

    public synchronized void freeze() {
        if (!this.baseGraph.isFrozen()) {
            this.baseGraph.freeze();
        }
    }

    boolean isFrozen() {
        return this.baseGraph.isFrozen();
    }

    @Override
    public String toDetailsString() {
        String str = this.baseGraph.toDetailsString();
        for (CHGraphImpl cg : this.getAllCHGraphs()) {
            str = str + ", " + cg.toDetailsString();
        }
        return str;
    }

    public String toString() {
        return (this.isCHPossible() ? "CH|" : "") + this.encodingManager + "|" + this.getDirectory().getDefaultType() + "|" + this.baseGraph.nodeAccess.getDimension() + "D|" + this.baseGraph.extStorage + "|" + this.getProperties().versionsToString();
    }

    @Override
    public Graph getBaseGraph() {
        return this.baseGraph;
    }

    @Override
    public int getNodes() {
        return this.baseGraph.getNodes();
    }

    @Override
    public int getEdges() {
        return this.getAllEdges().length();
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.baseGraph.getNodeAccess();
    }

    @Override
    public BBox getBounds() {
        return this.baseGraph.getBounds();
    }

    @Override
    public EdgeIteratorState edge(int a, int b) {
        return this.baseGraph.edge(a, b);
    }

    @Override
    public EdgeIteratorState edge(int a, int b, double distance, boolean bothDirections) {
        return this.baseGraph.edge(a, b, distance, bothDirections);
    }

    @Override
    public EdgeIteratorState getEdgeIteratorState(int edgeId, int adjNode) {
        return this.baseGraph.getEdgeIteratorState(edgeId, adjNode);
    }

    @Override
    public AllEdgesIterator getAllEdges() {
        return this.baseGraph.getAllEdges();
    }

    @Override
    public EdgeExplorer createEdgeExplorer(EdgeFilter filter) {
        return this.baseGraph.createEdgeExplorer(filter);
    }

    @Override
    public EdgeExplorer createEdgeExplorer() {
        return this.baseGraph.createEdgeExplorer();
    }

    @Override
    public Graph copyTo(Graph g) {
        return this.baseGraph.copyTo(g);
    }

    @Override
    public GraphExtension getExtension() {
        return this.baseGraph.getExtension();
    }

    @Override
    public int getOtherNode(int edge, int node) {
        return this.baseGraph.getOtherNode(edge, node);
    }

    @Override
    public boolean isAdjacentToNode(int edge, int node) {
        return this.baseGraph.isAdjacentToNode(edge, node);
    }

    private Collection<CHGraphImpl> getAllCHGraphs() {
        ArrayList<CHGraphImpl> result = new ArrayList<CHGraphImpl>(this.nodeBasedCHGraphs.size() + this.edgeBasedCHGraphs.size());
        result.addAll(this.nodeBasedCHGraphs);
        result.addAll(this.edgeBasedCHGraphs);
        return result;
    }
}

